/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.catalog.impl.AbstractCamelCatalog;

public abstract class AbstractCachingCamelCatalog
extends AbstractCamelCatalog {
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private boolean caching;

    protected AbstractCachingCamelCatalog() {
        this(false);
    }

    protected AbstractCachingCamelCatalog(boolean caching) {
        this.caching = caching;
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
        if (!this.caching) {
            this.clearCache();
        }
    }

    protected Map<String, Object> getCache() {
        return this.cache;
    }

    protected void clearCache() {
        this.cache.clear();
    }

    protected <T> T cache(String key, String name, Function<String, T> loader) {
        return this.doGetCache(key, name, loader);
    }

    protected <T> T cache(String name, Function<String, T> loader) {
        return this.doGetCache(name, name, loader);
    }

    protected <T> T cache(String name, Supplier<T> loader) {
        if (this.caching) {
            Object t = this.cache.get(name);
            if (t == null && (t = loader.get()) != null) {
                this.cache.put(name, t);
            }
            return (T)t;
        }
        return loader.get();
    }

    protected <T> T doGetCache(String key, String name, Function<String, T> loader) {
        if (this.caching) {
            Object t = this.cache.get(key);
            if (t == null && (t = loader.apply(name)) != null) {
                this.cache.put(key, t);
            }
            return (T)t;
        }
        return loader.apply(name);
    }
}

