/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.restrictions.CustomIndexExpression;
import org.apache.cassandra.cql3.restrictions.Restrictions;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class IndexRestrictions {
    public static final String INDEX_NOT_FOUND = "Invalid index expression, index %s not found for %s";
    public static final String INVALID_INDEX = "Target index %s cannot be used to query %s";
    public static final String CUSTOM_EXPRESSION_NOT_SUPPORTED = "Index %s does not support custom expressions";
    public static final String NON_CUSTOM_INDEX_IN_EXPRESSION = "Only CUSTOM indexes may be used in custom index expressions, %s is not valid";
    public static final String MULTIPLE_EXPRESSIONS = "Multiple custom index expressions in a single query are not supported";
    private final List<Restrictions> regularRestrictions = new ArrayList<Restrictions>();
    private final List<CustomIndexExpression> customExpressions = new ArrayList<CustomIndexExpression>();

    public void add(Restrictions restrictions) {
        this.regularRestrictions.add(restrictions);
    }

    public void add(CustomIndexExpression expression) {
        this.customExpressions.add(expression);
    }

    public boolean isEmpty() {
        return this.regularRestrictions.isEmpty() && this.customExpressions.isEmpty();
    }

    public List<Restrictions> getRestrictions() {
        return this.regularRestrictions;
    }

    public List<CustomIndexExpression> getCustomIndexExpressions() {
        return this.customExpressions;
    }

    public boolean needsFiltering(IndexRegistry indexRegistry) {
        if (this.isEmpty()) {
            return false;
        }
        for (Index.Group group : indexRegistry.listIndexGroups()) {
            if (this.needsFiltering(group)) continue;
            return false;
        }
        return true;
    }

    private boolean needsFiltering(Index.Group indexGroup) {
        for (Restrictions restrictions : this.regularRestrictions) {
            if (!restrictions.needsFiltering(indexGroup)) continue;
            return true;
        }
        for (CustomIndexExpression restriction : this.customExpressions) {
            if (!restriction.needsFiltering(indexGroup)) continue;
            return true;
        }
        return false;
    }

    static InvalidRequestException invalidIndex(QualifiedName indexName, TableMetadata table) {
        return new InvalidRequestException(String.format(INVALID_INDEX, indexName.getName(), table));
    }

    static InvalidRequestException indexNotFound(QualifiedName indexName, TableMetadata table) {
        return new InvalidRequestException(String.format(INDEX_NOT_FOUND, indexName.getName(), table));
    }

    static InvalidRequestException nonCustomIndexInExpression(QualifiedName indexName) {
        return new InvalidRequestException(String.format(NON_CUSTOM_INDEX_IN_EXPRESSION, indexName.getName()));
    }

    static InvalidRequestException customExpressionNotSupported(QualifiedName indexName) {
        return new InvalidRequestException(String.format(CUSTOM_EXPRESSION_NOT_SUPPORTED, indexName.getName()));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

