/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.sasl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.apache.celeborn.common.network.sasl.anonymous.AnonymousSaslProvider;

public class SaslUtils {
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String DIGEST_MD5 = "DIGEST-MD5";
    public static final String ANONYMOUS = "ANONYMOUS";
    static final String QOP_AUTH = "auth";
    static final String DEFAULT_REALM = "default";
    public static final Map<String, String> DEFAULT_SASL_CLIENT_PROPS = ImmutableMap.builder().put((Object)"javax.security.sasl.qop", (Object)"auth").build();
    static final Map<String, String> DEFAULT_SASL_SERVER_PROPS = ImmutableMap.builder().put((Object)"javax.security.sasl.server.authentication", (Object)"true").put((Object)"javax.security.sasl.qop", (Object)"auth").build();

    static String encodeIdentifier(String identifier) {
        Preconditions.checkNotNull((Object)identifier, (Object)"User cannot be null if SASL is enabled");
        return Base64.getEncoder().encodeToString(identifier.getBytes(StandardCharsets.UTF_8));
    }

    static String decodeIdentifier(String identifier) {
        Preconditions.checkNotNull((Object)identifier, (Object)"User cannot be null if SASL is enabled");
        return new String(Base64.getDecoder().decode(identifier.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    static char[] encodePassword(String password) {
        Preconditions.checkNotNull((Object)password, (Object)"Password cannot be null if SASL is enabled");
        return Base64.getEncoder().encodeToString(password.getBytes(StandardCharsets.UTF_8)).toCharArray();
    }

    static void initializeSaslProviders() {
        AnonymousSaslProvider.initializeIfNeeded();
    }
}

