/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.store.db;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.server.common.service.config.ConfigLevel;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.celeborn.server.common.service.config.TenantConfig;
import org.apache.celeborn.server.common.service.model.ClusterInfo;
import org.apache.celeborn.server.common.service.model.ClusterSystemConfig;
import org.apache.celeborn.server.common.service.model.ClusterTag;
import org.apache.celeborn.server.common.service.model.ClusterTenantConfig;
import org.apache.celeborn.server.common.service.store.IServiceManager;
import org.apache.celeborn.server.common.service.store.db.DBSessionFactory;
import org.apache.celeborn.server.common.service.store.db.mapper.ClusterInfoMapper;
import org.apache.celeborn.server.common.service.store.db.mapper.ClusterSystemConfigMapper;
import org.apache.celeborn.server.common.service.store.db.mapper.ClusterTagsMapper;
import org.apache.celeborn.server.common.service.store.db.mapper.ClusterTenantConfigMapper;
import org.apache.celeborn.server.common.service.utils.JsonUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbServiceManagerImpl
implements IServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(DbServiceManagerImpl.class);
    private final CelebornConf celebornConf;
    private final ConfigService configService;
    private final SqlSessionFactory sqlSessionFactory;
    private final int clusterId;
    private final int pageSize;

    public DbServiceManagerImpl(CelebornConf celebornConf, ConfigService configServer) throws IOException {
        this.celebornConf = celebornConf;
        this.sqlSessionFactory = DBSessionFactory.get(celebornConf);
        this.configService = configServer;
        this.pageSize = celebornConf.dynamicConfigStoreDbFetchPageSize();
        this.clusterId = this.createCluster(this.getClusterInfoFromEnv());
    }

    @Override
    public int createCluster(ClusterInfo clusterInfo) {
        ClusterInfo clusterInfoFromDB = this.getClusterInfo(clusterInfo.getName());
        if (clusterInfoFromDB == null) {
            try (SqlSession sqlSession = this.sqlSessionFactory.openSession(true);){
                ClusterInfoMapper mapper = (ClusterInfoMapper)sqlSession.getMapper(ClusterInfoMapper.class);
                Instant now = Instant.now();
                clusterInfo.setGmtCreate(now);
                clusterInfo.setGmtModify(now);
                mapper.insert(clusterInfo);
                LOG.info("Create cluster {} successfully.", (Object)JsonUtils.toJson(clusterInfo));
            }
            catch (Exception e) {
                LOG.warn("Create cluster {} failed: {}.", new Object[]{JsonUtils.toJson(clusterInfo), e.getMessage(), e});
            }
            clusterInfoFromDB = this.getClusterInfo(clusterInfo.getName());
            if (clusterInfoFromDB == null) {
                throw new RuntimeException("Could not get cluster info of " + clusterInfo.getName() + ".");
            }
        }
        return clusterInfoFromDB.getId();
    }

    @Override
    public ClusterInfo getClusterInfo(String clusterName) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            ClusterInfoMapper mapper = (ClusterInfoMapper)sqlSession.getMapper(ClusterInfoMapper.class);
            ClusterInfo clusterInfo = mapper.getClusterInfo(clusterName);
            return clusterInfo;
        }
    }

    @Override
    public List<TenantConfig> getAllTenantConfigs() {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            ClusterTenantConfigMapper mapper = (ClusterTenantConfigMapper)sqlSession.getMapper(ClusterTenantConfigMapper.class);
            int totalNum = mapper.getClusterTenantConfigsNum(this.clusterId, ConfigLevel.TENANT.name());
            ArrayList<ClusterTenantConfig> clusterAllTenantConfigs = new ArrayList<ClusterTenantConfig>();
            for (int offset = 0; offset < totalNum; offset += this.pageSize) {
                List<ClusterTenantConfig> clusterTenantConfigs = mapper.getClusterTenantConfigs(this.clusterId, ConfigLevel.TENANT.name(), offset, this.pageSize);
                clusterAllTenantConfigs.addAll(clusterTenantConfigs);
            }
            Map<String, List<ClusterTenantConfig>> tenantConfigMaps = clusterAllTenantConfigs.stream().collect(Collectors.groupingBy(clusterTenantConfig -> clusterTenantConfig.getTenantId()));
            List<TenantConfig> list = tenantConfigMaps.entrySet().stream().map(t -> new TenantConfig(this.configService, (String)t.getKey(), null, (List)t.getValue())).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<TenantConfig> getAllTenantUserConfigs() {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            ClusterTenantConfigMapper mapper = (ClusterTenantConfigMapper)sqlSession.getMapper(ClusterTenantConfigMapper.class);
            int totalNum = mapper.getClusterTenantConfigsNum(this.clusterId, ConfigLevel.TENANT_USER.name());
            ArrayList<ClusterTenantConfig> clusterAllTenantConfigs = new ArrayList<ClusterTenantConfig>();
            for (int offset = 0; offset < totalNum; offset += this.pageSize) {
                List<ClusterTenantConfig> clusterTenantConfigs = mapper.getClusterTenantConfigs(this.clusterId, ConfigLevel.TENANT_USER.name(), offset, this.pageSize);
                clusterAllTenantConfigs.addAll(clusterTenantConfigs);
            }
            Map<Pair, List<ClusterTenantConfig>> tenantConfigMaps = clusterAllTenantConfigs.stream().collect(Collectors.groupingBy(ClusterTenantConfig::getTenantInfo));
            List<TenantConfig> list = tenantConfigMaps.entrySet().stream().map(t -> new TenantConfig(this.configService, (String)((Pair)t.getKey()).getKey(), (String)((Pair)t.getKey()).getValue(), (List)t.getValue())).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<ClusterSystemConfig> getSystemConfig() {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            ClusterSystemConfigMapper mapper = (ClusterSystemConfigMapper)sqlSession.getMapper(ClusterSystemConfigMapper.class);
            List<ClusterSystemConfig> list = mapper.getClusterSystemConfig(this.clusterId);
            return list;
        }
    }

    public ClusterInfo getClusterInfoFromEnv() {
        Map<String, String> env = System.getenv();
        String clusterName = env.getOrDefault("CELEBORN_CLUSTER_NAME", this.celebornConf.clusterName());
        String namespace = env.getOrDefault("CELEBORN_CLUSTER_NAMESPACE", "");
        String endpoint = env.getOrDefault("CELEBORN_CLUSTER_ENDPOINT", "");
        ClusterInfo clusterInfo = new ClusterInfo();
        clusterInfo.setName(clusterName);
        clusterInfo.setNamespace(namespace);
        clusterInfo.setEndpoint(endpoint);
        return clusterInfo;
    }

    @Override
    public List<ClusterTag> getClusterTags() {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            ClusterTagsMapper mapper = (ClusterTagsMapper)sqlSession.getMapper(ClusterTagsMapper.class);
            List<ClusterTag> list = mapper.getClusterTags(this.clusterId);
            return list;
        }
    }

    @Override
    public void upsertSystemConfig(Map<String, String> systemConfigs) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession(true);){
            ClusterSystemConfigMapper mapper = (ClusterSystemConfigMapper)sqlSession.getMapper(ClusterSystemConfigMapper.class);
            for (Map.Entry<String, String> systemConfig : systemConfigs.entrySet()) {
                ClusterSystemConfig config = new ClusterSystemConfig();
                Instant now = Instant.now();
                config.setClusterId(this.clusterId);
                config.setConfigKey(systemConfig.getKey());
                config.setConfigValue(systemConfig.getValue());
                config.setGmtCreate(now);
                config.setGmtModify(now);
                int updated = mapper.update(config);
                if (updated != 0) continue;
                mapper.insert(config);
            }
        }
    }

    @Override
    public void upsertTenantConfig(ConfigLevel configLevel, String tenantId, String name, Map<String, String> tenantConfigs) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession(true);){
            ClusterTenantConfigMapper mapper = (ClusterTenantConfigMapper)sqlSession.getMapper(ClusterTenantConfigMapper.class);
            for (Map.Entry<String, String> systemConfig : tenantConfigs.entrySet()) {
                ClusterTenantConfig config = new ClusterTenantConfig();
                Instant now = Instant.now();
                config.setClusterId(this.clusterId);
                config.setLevel(configLevel.name());
                config.setTenantId(tenantId);
                config.setName(name);
                config.setConfigKey(systemConfig.getKey());
                config.setConfigValue(systemConfig.getValue());
                config.setGmtCreate(now);
                config.setGmtModify(now);
                int updated = ConfigLevel.TENANT.equals((Object)configLevel) ? mapper.updateConfig(config) : mapper.updateUserConfig(config);
                if (updated != 0) continue;
                mapper.insert(config);
            }
        }
    }

    @Override
    public void deleteSystemConfigByKeys(List<String> configKeys) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession(true);){
            ClusterSystemConfigMapper mapper = (ClusterSystemConfigMapper)sqlSession.getMapper(ClusterSystemConfigMapper.class);
            for (String configKey : configKeys) {
                ClusterSystemConfig config = new ClusterSystemConfig();
                config.setClusterId(this.clusterId);
                config.setConfigKey(configKey);
                mapper.delete(config);
            }
        }
    }

    @Override
    public void deleteTenantConfigByKeys(ConfigLevel configLevel, String tenantId, String name, List<String> configKeys) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession(true);){
            ClusterTenantConfigMapper mapper = (ClusterTenantConfigMapper)sqlSession.getMapper(ClusterTenantConfigMapper.class);
            for (String configKey : configKeys) {
                ClusterTenantConfig config = new ClusterTenantConfig();
                config.setClusterId(this.clusterId);
                config.setLevel(configLevel.name());
                config.setTenantId(tenantId);
                config.setName(name);
                config.setConfigKey(configKey);
                if (ConfigLevel.TENANT.equals((Object)configLevel)) {
                    mapper.deleteConfig(config);
                    continue;
                }
                mapper.deleteUserConfig(config);
            }
        }
    }
}

