/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.http.api.v1;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.celeborn.rest.v1.model.ApplicationHeartbeatData;
import org.apache.celeborn.rest.v1.model.ApplicationInfo;
import org.apache.celeborn.rest.v1.model.ApplicationInfoResponse;
import org.apache.celeborn.rest.v1.model.ApplicationsHeartbeatResponse;
import org.apache.celeborn.rest.v1.model.DeleteAppsRequest;
import org.apache.celeborn.rest.v1.model.HandleResponse;
import org.apache.celeborn.rest.v1.model.HostnamesResponse;
import org.apache.celeborn.rest.v1.model.ReviseLostShufflesRequest;
import org.apache.celeborn.server.common.HttpService;
import org.apache.celeborn.server.common.http.api.ApiRequestContext;
import org.apache.celeborn.service.deploy.master.Master;
import org.apache.celeborn.service.deploy.master.clustermeta.AbstractMetaManager;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Tag(name="Application")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001\u0002\u0005\n\u0001qAQ!\f\u0001\u0005\u00029BQ!\r\u0001\u0005\nIBQ!\u000f\u0001\u0005\u0002iBQA \u0001\u0005\u0002}Dq!a\n\u0001\t\u0003\tI\u0003C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~\t\u0019\u0012\t\u001d9mS\u000e\fG/[8o%\u0016\u001cx.\u001e:dK*\u0011!bC\u0001\u0003mFR!\u0001D\u0007\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u000f\u001f\u0005!\u0001\u000e\u001e;q\u0015\t\u0001\u0012#\u0001\u0004nCN$XM\u001d\u0006\u0003%M\ta\u0001Z3qY>L(B\u0001\u000b\u0016\u0003\u001d\u0019XM\u001d<jG\u0016T!AF\f\u0002\u0011\r,G.\u001a2pe:T!\u0001G\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0012aA8sO\u000e\u00011c\u0001\u0001\u001eGA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\u0004\"\u0001J\u0016\u000e\u0003\u0015R!\u0001\u0004\u0014\u000b\u000599#B\u0001\u0015*\u0003\u0019\u0019w.\\7p]*\u0011!&F\u0001\u0007g\u0016\u0014h/\u001a:\n\u00051*#!E!qSJ+\u0017/^3ti\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\u0012a\f\t\u0003a\u0001i\u0011!C\u0001\rgR\fG/^:TsN$X-\\\u000b\u0002gA\u0011AgN\u0007\u0002k)\u0011agD\u0001\fG2,8\u000f^3s[\u0016$\u0018-\u0003\u00029k\t\u0019\u0012IY:ue\u0006\u001cG/T3uC6\u000bg.Y4fe\u0006a\u0011\r\u001d9mS\u000e\fG/[8ogR\t1\b\u0005\u0002=\u00056\tQH\u0003\u0002?\u007f\u0005)Qn\u001c3fY*\u0011!\u0002\u0011\u0006\u0003\u0003V\tAA]3ti&\u00111)\u0010\u0002\u001e\u0003B\u0004H.[2bi&|gn\u001d%fCJ$(-Z1u%\u0016\u001c\bo\u001c8tK\"\u00121!\u0012\t\u0003\r6k\u0011a\u0012\u0006\u0003\u0011&\u000b!A]:\u000b\u0005)[\u0015AA<t\u0015\u0005a\u0015!\u00026bm\u0006D\u0018B\u0001(H\u0005\r9U\t\u0016\u0015\u0007\u0007A\u0003\u0017m\u00193\u0011\u0005EsV\"\u0001*\u000b\u0005M#\u0016!\u0003:fgB|gn]3t\u0015\t)f+A\u0006b]:|G/\u0019;j_:\u001c(BA,Y\u0003\ry\u0017m\u001d\u0006\u00033j\u000b!A^\u001a\u000b\u0005mc\u0016aB:xC\u001e<WM\u001d\u0006\u0002;\u0006\u0011\u0011n\\\u0005\u0003?J\u00131\"\u00119j%\u0016\u001c\bo\u001c8tK\u0006a!/Z:q_:\u001cXmQ8eK\u0006\n!-A\u00023aA\nqaY8oi\u0016tG\u000fL\u0001fW\u00151G.\\8q!\t9'.D\u0001i\u0015\tIG+A\u0003nK\u0012L\u0017-\u0003\u0002lQ\n91i\u001c8uK:$\u0018!C7fI&\fG+\u001f9fC\u0005q\u0017\u0001E1qa2L7-\u0019;j_:|#n]8o\u0003\u0019\u00198\r[3nC.\u001a\u0011\u000f^;\u0011\u0005\u001d\u0014\u0018BA:i\u0005\u0019\u00196\r[3nC\u0006q\u0011.\u001c9mK6,g\u000e^1uS>t7%A\u001e)\t\r98\u0010 \t\u0003qfl\u0011\u0001V\u0005\u0003uR\u0013\u0011b\u00149fe\u0006$\u0018n\u001c8\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0002{\u0006\u0011D*[:uA\u0005dG\u000e\t:v]:Lgn\u001a\u0011baBd\u0017nY1uS>twe\u001d\u0011jIN\u0004sN\u001a\u0011uQ\u0016\u00043\r\\;ti\u0016\u0014h&\u0001\tbaBd\u0017nY1uS>t7/\u00138g_R\u0011\u0011\u0011\u0001\t\u0004y\u0005\r\u0011bAA\u0003{\t9\u0012\t\u001d9mS\u000e\fG/[8o\u0013:4wNU3ta>t7/\u001a\u0015\b\t\u0005%\u0011qBA\t!\r1\u00151B\u0005\u0004\u0003\u001b9%\u0001\u0002)bi\"\fQA^1mk\u0016\f#!a\u0005\u0002\u000b=JgNZ8)\u0005\u0011)\u0005f\u0002\u0003QA\u0006\u001c\u0017\u0011\u0004\u0017\u0003\u00037YcA\u001a7n_\u0006u1\u0006B9u\u0003?\u0019#!!\u0001)\u000b\u0011980a\t\"\u0005\u0005\u0015\u0012a\r'jgR\u0004\u0013\r\u001c7!eVtg.\u001b8hA\u0005\u0004\b\u000f\\5dCRLwN\\\u0014tA%tgm\u001c\u0011pM\u0002\"\b.\u001a\u0011dYV\u001cH/\u001a:/\u0003)!W\r\\3uK\u0006\u0003\bo\u001d\u000b\u0005\u0003W\t\t\u0004E\u0002=\u0003[I1!a\f>\u00059A\u0015M\u001c3mKJ+7\u000f]8og\u0016Dq!a\r\u0006\u0001\u0004\t)$A\u0004sKF,Xm\u001d;\u0011\u0007q\n9$C\u0002\u0002:u\u0012\u0011\u0003R3mKR,\u0017\t\u001d9t%\u0016\fX/Z:uQ\u001d)\u0011\u0011BA\b\u0003{\t#!a\u0010\u0002\u0019=\"W\r\\3uK~\u000b\u0007\u000f]:)\u0007\u0015\t\u0019\u0005E\u0002G\u0003\u000bJ1!a\u0012H\u0005\u0011\u0001vj\u0015+)\u000f\u0015\u0001\u0006-Y2\u0002L1\u0012\u0011QJ\u0016\u0007M2lw.a\u0014,\tE$\u0018\u0011K\u0012\u0003\u0003WAS!B<|\u0003+\n#!a\u0016\u00021\u0011+G.\u001a;fAI,7o\\;sG\u0016\u0004sN\u001a\u0011baB\u001ch&A\u0005i_N$h.Y7fgR\u0011\u0011Q\f\t\u0004y\u0005}\u0013bAA1{\t\t\u0002j\\:u]\u0006lWm\u001d*fgB|gn]3)\u000f\u0019\tI!a\u0004\u0002f\u0005\u0012\u0011qM\u0001\u000b_!|7\u000f\u001e8b[\u0016\u001c\bF\u0001\u0004FQ\u001d1\u0001\u000bY1d\u0003[b#!a\u001c,\r\u0019dWn\\A9W\u0011\tH/a\u001d$\u0005\u0005u\u0003&\u0002\u0004xw\u0006]\u0014EAA=\u0003-c\u0015n\u001d;!C2d\u0007E];o]&tw\rI1qa2L7-\u0019;j_:<3\u000f\t'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3sOM\u0004\u0003n\\:u]\u0006lWm\u001d\u0011pM\u0002\"\b.\u001a\u0011dYV\u001cH/\u001a:/\u0003I\u0011XM^5tK2{7\u000f^*ik\u001a4G.Z:\u0015\t\u0005-\u0012q\u0010\u0005\b\u0003g9\u0001\u0019AAA!\ra\u00141Q\u0005\u0004\u0003\u000bk$!\u0007*fm&\u001cX\rT8tiNCWO\u001a4mKN\u0014V-];fgRD3aBA\"Q\u001d9\u0001\u000bY1d\u0003\u0017c#!!\u0014)\u000f\u001d\tI!a\u0004\u0002\u0010\u0006\u0012\u0011\u0011S\u0001\u0016_I,g/[:f?2|7\u000f^0tQV4g\r\\3tQ\u00159qo_AKC\t\t9*A\u001eSKZL7/\u001a\u0011m_N$\be\u001d5vM\u001adWm\u001d\u0011pe\u0002\"W\r\\3uK\u0012\u00043\u000f[;gM2,7\u000fI8gA\u0005t\u0007%\u00199qY&\u001c\u0017\r^5p]:Bs\u0001AAN\u0003\u001f\t\t\u000bE\u0002G\u0003;K1!a(H\u0005!\u0019uN\\:v[\u0016\u001cH&A7)\u000f\u0001\t)+a\u0004\u0002,B\u0019a)a*\n\u0007\u0005%vI\u0001\u0005Qe>$WoY3tY\u0005i\u0007f\u0002\u0001\u00020\u0006m\u0016Q\u0018\t\u0005\u0003c\u000b9,\u0004\u0002\u00024*\u0019\u0011Q\u0017+\u0002\tQ\fwm]\u0005\u0005\u0003s\u000b\u0019LA\u0002UC\u001e\fAA\\1nK\u0006\u0012\u0011qX\u0001\f\u0003B\u0004H.[2bi&|g\u000e")
public class ApplicationResource
implements ApiRequestContext {
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public final HttpService httpService() {
        return ApiRequestContext.httpService$((ApiRequestContext)this);
    }

    public String normalizeParam(String param) {
        return ApiRequestContext.normalizeParam$((ApiRequestContext)this, (String)param);
    }

    public ServletContext servletContext() {
        return this.servletContext;
    }

    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private AbstractMetaManager statusSystem() {
        return ((Master)this.httpService()).statusSystem();
    }

    @Operation(description="List all running application's ids of the cluster.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationsHeartbeatResponse.class))})
    @GET
    public ApplicationsHeartbeatResponse applications() {
        return new ApplicationsHeartbeatResponse().applications((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.statusSystem().appHeartbeatTime).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String appId = (String)tuple2._1();
                Long heartbeat = (Long)tuple2._2();
                return new ApplicationHeartbeatData().appId(appId).lastHeartbeatTimestamp(heartbeat);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq()).asJava());
    }

    @Operation(description="List all running application's info of the cluster.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationInfoResponse.class))})
    @GET
    @Path(value="/info")
    public ApplicationInfoResponse applicationsInfo() {
        return new ApplicationInfoResponse().applications((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.statusSystem().applicationInfos).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String appId = (String)tuple2._1();
                org.apache.celeborn.common.meta.ApplicationInfo appInfo = (org.apache.celeborn.common.meta.ApplicationInfo)tuple2._2();
                return new ApplicationInfo().appId(appId).userIdentifier(appInfo.userIdentifier().toString()).extraInfo(appInfo.extraInfo()).registrationTime(Predef$.MODULE$.long2Long(appInfo.registrationTime()));
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq()).asJava());
    }

    @Operation(description="Delete resource of apps.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/delete_apps")
    public HandleResponse deleteApps(DeleteAppsRequest request) {
        Buffer apps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(request.getApps()).asScala();
        apps.foreach((Function1 & Serializable & scala.Serializable)app -> {
            ApplicationResource.$anonfun$deleteApps$1(this, app);
            return BoxedUnit.UNIT;
        });
        return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(24).append("deleted shuffles of app ").append(apps).toString());
    }

    @Operation(description="List all running application's LifecycleManager's hostnames of the cluster.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HostnamesResponse.class))})
    @GET
    @Path(value="/hostnames")
    public HostnamesResponse hostnames() {
        return new HostnamesResponse().hostnames((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.statusSystem().hostnameSet).asScala()).toSeq()).asJava());
    }

    @Operation(description="Revise lost shuffles or deleted shuffles of an application.")
    @Path(value="/revise_lost_shuffles")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    public HandleResponse reviseLostShuffles(ReviseLostShufflesRequest request) {
        String appId = request.getAppId();
        List shuffleIds = request.getShuffleIds();
        this.statusSystem().reviseLostShuffles(appId, shuffleIds);
        return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(27).append("revised app:").append(appId).append(" lost shuffles:").append(shuffleIds).toString());
    }

    public static final /* synthetic */ void $anonfun$deleteApps$1(ApplicationResource $this, String app) {
        $this.statusSystem().deleteApp(app);
    }

    public ApplicationResource() {
        ApiRequestContext.$init$((ApiRequestContext)this);
    }
}

