/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import org.apache.celeborn.common.CelebornConf;
import org.apache.spark.SparkConf;
import org.apache.spark.shuffle.api.ShuffleDataIO;
import org.apache.spark.shuffle.api.ShuffleDriverComponents;
import org.apache.spark.shuffle.api.ShuffleExecutorComponents;
import org.apache.spark.shuffle.celeborn.CelebornShuffleDriverComponents;
import org.apache.spark.shuffle.celeborn.SparkUtils;
import org.apache.spark.shuffle.sort.io.LocalDiskShuffleExecutorComponents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornShuffleDataIO
implements ShuffleDataIO {
    private static final Logger logger = LoggerFactory.getLogger(CelebornShuffleDataIO.class);
    private final SparkConf sparkConf;
    private final CelebornConf celebornConf;

    public CelebornShuffleDataIO(SparkConf sparkConf) {
        logger.info("Loading CelebornShuffleDataIO");
        this.sparkConf = sparkConf;
        this.celebornConf = SparkUtils.fromSparkConf(sparkConf);
    }

    public ShuffleExecutorComponents executor() {
        return new LocalDiskShuffleExecutorComponents(this.sparkConf);
    }

    public ShuffleDriverComponents driver() {
        return new CelebornShuffleDriverComponents(this.celebornConf);
    }
}

