/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.protocol;

import java.util.Objects;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;

public class ReadData
extends RequestMessage {
    protected final long streamId;
    protected ByteBuf flinkBuffer;

    @Override
    public boolean needCopyOut() {
        return true;
    }

    public ReadData(long streamId) {
        this.streamId = streamId;
    }

    @Override
    public int encodedLength() {
        return 8;
    }

    @Override
    public void encode(org.apache.celeborn.shaded.io.netty.buffer.ByteBuf buf) {
        buf.writeLong(this.streamId);
    }

    public long getStreamId() {
        return this.streamId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.READ_DATA;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadData readData = (ReadData)o;
        return this.streamId == readData.streamId && Objects.equals(this.flinkBuffer, readData.flinkBuffer);
    }

    public int hashCode() {
        return Objects.hash(this.streamId, this.flinkBuffer);
    }

    public String toString() {
        return "ReadData{streamId=" + this.streamId + ", flinkBuffer=" + this.flinkBuffer + '}';
    }

    public ByteBuf getFlinkBuffer() {
        return this.flinkBuffer;
    }

    public void setFlinkBuffer(ByteBuf flinkBuffer) {
        this.flinkBuffer = flinkBuffer;
    }
}

