/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.serializer;

import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.celeborn.common.network.protocol.SerdeVersion;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.serializer.DeserializationStream;
import org.apache.celeborn.common.serializer.JavaDeserializationStream;
import org.apache.celeborn.common.serializer.JavaSerializationStream;
import org.apache.celeborn.common.serializer.SerializationStream;
import org.apache.celeborn.common.serializer.SerializerInstance;
import org.apache.celeborn.common.util.ByteBufferInputStream;
import org.apache.celeborn.common.util.ByteBufferOutputStream;
import org.apache.celeborn.common.util.Utils$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%a!B\u0006\r\u0001A1\u0002\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006a\u0001!\t!\r\u0005\u0006m\u0001!\te\u000e\u0005\u0006+\u0002!\tE\u0016\u0005\u0006+\u0002!\t\u0005\u0019\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0006q\u0002!\t%\u001f\u0005\u0007q\u0002!\t!a\u0001\u0003-)\u000bg/Y*fe&\fG.\u001b>fe&s7\u000f^1oG\u0016T!!\u0004\b\u0002\u0015M,'/[1mSj,'O\u0003\u0002\u0010!\u000511m\\7n_:T!!\u0005\n\u0002\u0011\r,G.\u001a2pe:T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sON\u0011\u0001a\u0006\t\u00031ei\u0011\u0001D\u0005\u000351\u0011!cU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dK\u0006a1m\\;oi\u0016\u0014(+Z:fi\u000e\u0001\u0001C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"aA%oi\u0006qQ\r\u001f;sC\u0012+'-^4J]\u001a|\u0007C\u0001\u0010&\u0013\t1sDA\u0004C_>dW-\u00198\u0002%\u0011,g-Y;mi\u000ec\u0017m]:M_\u0006$WM\u001d\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nA\u0001\\1oO*\tQ&\u0001\u0003kCZ\f\u0017BA\u0018+\u0005-\u0019E.Y:t\u0019>\fG-\u001a:\u0002\rqJg.\u001b;?)\u0011\u00114\u0007N\u001b\u0011\u0005a\u0001\u0001\"B\u000e\u0005\u0001\u0004i\u0002\"B\u0012\u0005\u0001\u0004!\u0003\"B\u0014\u0005\u0001\u0004A\u0013!C:fe&\fG.\u001b>f+\tA$\n\u0006\u0002:'R\u0011!\b\u0011\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{1\n1A\\5p\u0013\tyDH\u0001\u0006CsR,')\u001e4gKJDq!Q\u0003\u0002\u0002\u0003\u000f!)\u0001\u0006fm&$WM\\2fIM\u00022a\u0011$I\u001b\u0005!%BA# \u0003\u001d\u0011XM\u001a7fGRL!a\u0012#\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"!\u0013&\r\u0001\u0011)1*\u0002b\u0001\u0019\n\tA+\u0005\u0002N!B\u0011aDT\u0005\u0003\u001f~\u0011qAT8uQ&tw\r\u0005\u0002\u001f#&\u0011!k\b\u0002\u0004\u0003:L\b\"\u0002+\u0006\u0001\u0004A\u0015!\u0001;\u0002\u0017\u0011,7/\u001a:jC2L'0Z\u000b\u0003/j#\"\u0001\u00170\u0015\u0005e[\u0006CA%[\t\u0015YeA1\u0001M\u0011\u001daf!!AA\u0004u\u000b!\"\u001a<jI\u0016t7-\u001a\u00135!\r\u0019e)\u0017\u0005\u0006?\u001a\u0001\rAO\u0001\u0006Ef$Xm]\u000b\u0003C\u0012$2A\u00195j)\t\u0019W\r\u0005\u0002JI\u0012)1j\u0002b\u0001\u0019\"9amBA\u0001\u0002\b9\u0017AC3wS\u0012,gnY3%kA\u00191IR2\t\u000b};\u0001\u0019\u0001\u001e\t\u000b)<\u0001\u0019\u0001\u0015\u0002\r1|\u0017\rZ3s\u0003=\u0019XM]5bY&TXm\u0015;sK\u0006lGCA7q!\tAb.\u0003\u0002p\u0019\t\u00192+\u001a:jC2L'0\u0019;j_:\u001cFO]3b[\")\u0011\u000f\u0003a\u0001e\u0006\t1\u000f\u0005\u0002tm6\tAO\u0003\u0002vY\u0005\u0011\u0011n\\\u0005\u0003oR\u0014AbT;uaV$8\u000b\u001e:fC6\f\u0011\u0003Z3tKJL\u0017\r\\5{KN#(/Z1n)\tQX\u0010\u0005\u0002\u0019w&\u0011A\u0010\u0004\u0002\u0016\t\u0016\u001cXM]5bY&T\u0018\r^5p]N#(/Z1n\u0011\u0015\t\u0018\u00021\u0001\u007f!\t\u0019x0C\u0002\u0002\u0002Q\u00141\"\u00138qkR\u001cFO]3b[R)!0!\u0002\u0002\b!)\u0011O\u0003a\u0001}\")!N\u0003a\u0001Q\u0001")
public class JavaSerializerInstance
extends SerializerInstance {
    private final int counterReset;
    private final boolean extraDebugInfo;
    private final ClassLoader defaultClassLoader;

    @Override
    public <T> ByteBuffer serialize(T t, ClassTag<T> evidence$3) {
        ByteBufferOutputStream bos = new ByteBufferOutputStream();
        Object msg = Utils$.MODULE$.toTransportMessage(t);
        Object object = msg;
        if (object instanceof TransportMessage) {
            TransportMessage transportMessage = (TransportMessage)object;
            SerdeVersion serdeVersion = transportMessage.getSerdeVersion();
            SerdeVersion serdeVersion2 = SerdeVersion.V2;
            if (!(serdeVersion != null ? !((Object)((Object)serdeVersion)).equals((Object)serdeVersion2) : serdeVersion2 != null)) {
                DataOutputStream out = new DataOutputStream(bos);
                out.writeByte(SerdeVersion.V2.getMarker());
                out.write(transportMessage.toByteBuffer().array());
                out.close();
                return bos.toByteBuffer();
            }
        }
        SerializationStream out = this.serializeStream(bos);
        out.writeObject(Utils$.MODULE$.toTransportMessage(t), ClassTag$.MODULE$.Any());
        out.close();
        return bos.toByteBuffer();
    }

    @Override
    public <T> T deserialize(ByteBuffer bytes, ClassTag<T> evidence$4) {
        bytes.mark();
        byte serdeVersion = bytes.get();
        if (serdeVersion == SerdeVersion.V2.getMarker()) {
            return (T)Utils$.MODULE$.fromTransportMessage(TransportMessage.fromByteBuffer(bytes, SerdeVersion.V2));
        }
        bytes.reset();
        ByteBufferInputStream bis = new ByteBufferInputStream(bytes);
        DeserializationStream in = this.deserializeStream(bis);
        return (T)Utils$.MODULE$.fromTransportMessage(in.readObject(evidence$4));
    }

    @Override
    public <T> T deserialize(ByteBuffer bytes, ClassLoader loader, ClassTag<T> evidence$5) {
        bytes.mark();
        byte serdeVersion = bytes.get();
        if (serdeVersion == SerdeVersion.V2.getMarker()) {
            return (T)Utils$.MODULE$.fromTransportMessage(TransportMessage.fromByteBuffer(bytes, SerdeVersion.V2));
        }
        bytes.reset();
        ByteBufferInputStream bis = new ByteBufferInputStream(bytes);
        DeserializationStream in = this.deserializeStream(bis, loader);
        return (T)Utils$.MODULE$.fromTransportMessage(in.readObject(evidence$5));
    }

    @Override
    public SerializationStream serializeStream(OutputStream s) {
        return new JavaSerializationStream(s, this.counterReset, this.extraDebugInfo);
    }

    @Override
    public DeserializationStream deserializeStream(InputStream s) {
        return new JavaDeserializationStream(s, this.defaultClassLoader);
    }

    public DeserializationStream deserializeStream(InputStream s, ClassLoader loader) {
        return new JavaDeserializationStream(s, loader);
    }

    public JavaSerializerInstance(int counterReset, boolean extraDebugInfo, ClassLoader defaultClassLoader) {
        this.counterReset = counterReset;
        this.extraDebugInfo = extraDebugInfo;
        this.defaultClassLoader = defaultClassLoader;
    }
}

