/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import org.apache.celeborn.plugin.flink.utils.FlinkUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.ProducerDescriptor;

public class FlinkResultPartitionInfo {
    private final JobID jobID;
    private final ResultPartitionID resultPartitionId;
    private final IntermediateResultPartitionID partitionId;
    private final ExecutionAttemptID producerId;

    public FlinkResultPartitionInfo(JobID jobID, ResultPartitionID resultPartitionId) {
        this.jobID = jobID;
        this.resultPartitionId = resultPartitionId;
        this.partitionId = resultPartitionId.getPartitionId();
        this.producerId = resultPartitionId.getProducerId();
    }

    public FlinkResultPartitionInfo(JobID jobID, PartitionDescriptor partitionDescriptor, ProducerDescriptor producerDescriptor) {
        this.jobID = jobID;
        this.resultPartitionId = new ResultPartitionID(partitionDescriptor.getPartitionId(), producerDescriptor.getProducerExecutionId());
        this.partitionId = partitionDescriptor.getPartitionId();
        this.producerId = producerDescriptor.getProducerExecutionId();
    }

    public ResultPartitionID getResultPartitionId() {
        return this.resultPartitionId;
    }

    public String getShuffleId() {
        return FlinkUtils.toShuffleId(this.jobID, this.partitionId.getIntermediateDataSetID());
    }

    public int getTaskId() {
        return this.partitionId.getPartitionNumber();
    }

    public String getAttemptId() {
        return FlinkUtils.toAttemptId(this.producerId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FlinkResultPartitionInfo{");
        sb.append("jobID=").append(this.jobID);
        sb.append(", resultPartitionId=").append(this.resultPartitionId);
        sb.append(", partitionId=").append(this.partitionId);
        sb.append(", producerId=").append(this.producerId);
        sb.append('}');
        return sb.toString();
    }
}

