/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.tiered;

import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.plugin.flink.tiered.CelebornChannelBufferReader;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornChannelBufferManager
implements BufferListener,
BufferRecycler {
    private static Logger logger = LoggerFactory.getLogger(CelebornChannelBufferManager.class);
    private final Queue<Buffer> bufferQueue;
    private final TieredStorageMemoryManager memoryManager;
    private final CelebornChannelBufferReader bufferReader;
    @GuardedBy(value="bufferQueue")
    private boolean isWaitingForFloatingBuffers;
    @GuardedBy(value="bufferQueue")
    private int numRequiredBuffers = 0;

    public CelebornChannelBufferManager(TieredStorageMemoryManager memoryManager, CelebornChannelBufferReader bufferReader) {
        this.memoryManager = (TieredStorageMemoryManager)Preconditions.checkNotNull((Object)memoryManager);
        this.bufferReader = (CelebornChannelBufferReader)Preconditions.checkNotNull((Object)bufferReader);
        this.bufferQueue = new LinkedList<Buffer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyBufferAvailable(Buffer buffer) {
        if (this.bufferReader.isClosed()) {
            return false;
        }
        int numBuffers = 0;
        boolean isBufferUsed = false;
        try {
            Queue<Buffer> queue = this.bufferQueue;
            synchronized (queue) {
                if (!this.isWaitingForFloatingBuffers) {
                    logger.warn("This channel should be waiting for floating buffers.");
                    return false;
                }
                this.isWaitingForFloatingBuffers = false;
                if (this.bufferReader.isClosed() || this.bufferQueue.size() >= this.numRequiredBuffers) {
                    return false;
                }
                this.bufferQueue.add(buffer);
                isBufferUsed = true;
                numBuffers = 1 + this.tryRequestBuffers();
                this.decreaseRequiredCredits(numBuffers);
            }
            this.bufferReader.notifyAvailableCredits(numBuffers);
        }
        catch (Throwable t) {
            this.bufferReader.errorReceived(t.getLocalizedMessage());
        }
        return isBufferUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseRequiredCredits(int numCredits) {
        Queue<Buffer> queue = this.bufferQueue;
        synchronized (queue) {
            this.numRequiredBuffers -= numCredits;
        }
    }

    public void notifyBufferDestroyed() {
    }

    public void recycle(MemorySegment segment) {
        try {
            this.memoryManager.getBufferPool().recycle(segment);
        }
        catch (Throwable t) {
            ExceptionUtils.rethrow((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Buffer requestBuffer() {
        Queue<Buffer> queue = this.bufferQueue;
        synchronized (queue) {
            return this.bufferQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int requestBuffers(int numRequired) {
        int numRequestedBuffers = 0;
        Queue<Buffer> queue = this.bufferQueue;
        synchronized (queue) {
            if (this.bufferReader.isClosed()) {
                return numRequestedBuffers;
            }
            this.numRequiredBuffers += numRequired;
            numRequestedBuffers = this.tryRequestBuffers();
        }
        return numRequestedBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int tryRequestBuffersIfNeeded() {
        Queue<Buffer> queue = this.bufferQueue;
        synchronized (queue) {
            if (this.numRequiredBuffers > 0 && !this.isWaitingForFloatingBuffers && this.bufferQueue.isEmpty()) {
                return this.tryRequestBuffers();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Queue<Buffer> queue = this.bufferQueue;
        synchronized (queue) {
            for (Buffer buffer : this.bufferQueue) {
                buffer.recycleBuffer();
            }
            this.bufferQueue.clear();
        }
    }

    @GuardedBy(value="bufferQueue")
    private int tryRequestBuffers() {
        assert (Thread.holdsLock(this.bufferQueue));
        int numRequestedBuffers = 0;
        while (this.bufferQueue.size() < this.numRequiredBuffers && !this.isWaitingForFloatingBuffers) {
            BufferPool bufferPool = this.memoryManager.getBufferPool();
            Buffer buffer = bufferPool.requestBuffer();
            if (buffer != null) {
                this.bufferQueue.add(buffer);
                ++numRequestedBuffers;
                continue;
            }
            if (!bufferPool.addBufferListener((BufferListener)this)) continue;
            this.isWaitingForFloatingBuffers = true;
            break;
        }
        return numRequestedBuffers;
    }
}

