/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.network.protocol.TransportableError;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbBufferStreamEnd;
import org.apache.celeborn.common.protocol.PbNotifyRequiredSegment;
import org.apache.celeborn.common.protocol.PbOpenStream;
import org.apache.celeborn.common.protocol.PbReadAddCredit;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.StreamType;
import org.apache.celeborn.plugin.flink.client.FlinkShuffleClientImpl;
import org.apache.celeborn.plugin.flink.network.FlinkTransportClientFactory;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornBufferStream {
    private static Logger logger = LoggerFactory.getLogger(CelebornBufferStream.class);
    private FlinkTransportClientFactory clientFactory;
    private String shuffleKey;
    private PartitionLocation[] locations;
    private int subIndexStart;
    private int subIndexEnd;
    private long pushDataTimeoutMs;
    private TransportClient client;
    private AtomicInteger currentLocationIndex = new AtomicInteger(0);
    private long streamId = 0L;
    private FlinkShuffleClientImpl mapShuffleClient;
    private boolean isClosed;
    private boolean isOpenSuccess;
    private final Object lock = new Object();
    private Supplier<ByteBuf> bufferSupplier;
    private int initialCredit;
    private Consumer<RequestMessage> messageConsumer;
    private ExecutorService openStreamThreadPool;
    private static final CelebornBufferStream EMPTY_CELEBORN_BUFFER_STREAM = new CelebornBufferStream();

    public CelebornBufferStream() {
    }

    public CelebornBufferStream(FlinkShuffleClientImpl mapShuffleClient, FlinkTransportClientFactory dataClientFactory, String shuffleKey, PartitionLocation[] locations, int subIndexStart, int subIndexEnd, long pushDataTimeoutMs, ExecutorService openStreamThreadPool) {
        this.mapShuffleClient = mapShuffleClient;
        this.clientFactory = dataClientFactory;
        this.shuffleKey = shuffleKey;
        this.locations = locations;
        this.subIndexStart = subIndexStart;
        this.subIndexEnd = subIndexEnd;
        this.pushDataTimeoutMs = pushDataTimeoutMs;
        this.openStreamThreadPool = openStreamThreadPool;
    }

    public void open(Supplier<ByteBuf> bufferSupplier, int initialCredit, Consumer<RequestMessage> messageConsumer, boolean sync) {
        this.bufferSupplier = bufferSupplier;
        this.initialCredit = initialCredit;
        this.messageConsumer = messageConsumer;
        this.moveToNextPartitionIfPossible(0L, null, sync);
    }

    public void addCredit(PbReadAddCredit pbReadAddCredit) {
        this.client.sendRpc(new TransportMessage(MessageType.READ_ADD_CREDIT, pbReadAddCredit.toByteArray()).toByteBuffer(), new RpcResponseCallback(){

            @Override
            public void onSuccess(ByteBuffer response) {
            }

            @Override
            public void onFailure(Throwable e) {
                logger.error("Send PbReadAddCredit to {} failed, streamId {}, detail {}", new Object[]{NettyUtils.getRemoteAddress(CelebornBufferStream.this.client.getChannel()), CelebornBufferStream.this.streamId, e.getCause()});
                CelebornBufferStream.this.messageConsumer.accept(new TransportableError(CelebornBufferStream.this.streamId, e));
            }
        });
    }

    public void notifyRequiredSegment(PbNotifyRequiredSegment pbNotifyRequiredSegment) {
        this.client.sendRpc(new TransportMessage(MessageType.NOTIFY_REQUIRED_SEGMENT, pbNotifyRequiredSegment.toByteArray()).toByteBuffer(), new RpcResponseCallback(){

            @Override
            public void onSuccess(ByteBuffer response) {
            }

            @Override
            public void onFailure(Throwable e) {
                logger.error("Send PbNotifyRequiredSegment to {} failed, streamId {}, detail {}", new Object[]{NettyUtils.getRemoteAddress(CelebornBufferStream.this.client.getChannel()), CelebornBufferStream.this.streamId, e.getCause()});
                CelebornBufferStream.this.messageConsumer.accept(new TransportableError(CelebornBufferStream.this.streamId, e));
            }
        });
    }

    public static CelebornBufferStream empty() {
        return EMPTY_CELEBORN_BUFFER_STREAM;
    }

    public static boolean isEmptyStream(CelebornBufferStream stream) {
        return stream == null || stream == EMPTY_CELEBORN_BUFFER_STREAM;
    }

    public long getStreamId() {
        return this.streamId;
    }

    public static CelebornBufferStream create(FlinkShuffleClientImpl client, FlinkTransportClientFactory dataClientFactory, String shuffleKey, PartitionLocation[] locations, int subIndexStart, int subIndexEnd, long pushDataTimeoutMs, ExecutorService openStreamThreadPool) {
        if (locations == null || locations.length == 0) {
            return CelebornBufferStream.empty();
        }
        return new CelebornBufferStream(client, dataClientFactory, shuffleKey, locations, subIndexStart, subIndexEnd, pushDataTimeoutMs, openStreamThreadPool);
    }

    private void closeStream(long streamId) {
        if (this.client != null && this.client.isActive()) {
            this.client.sendRpc(new TransportMessage(MessageType.BUFFER_STREAM_END, PbBufferStreamEnd.newBuilder().setStreamType(StreamType.CreditStream).setStreamId(streamId).build().toByteArray()).toByteBuffer());
        }
    }

    private void cleanupStream(long streamId) {
        if (this.isOpenSuccess) {
            this.mapShuffleClient.getReadClientHandler().removeHandler(streamId);
            this.clientFactory.unregisterSupplier(streamId);
            this.closeStream(streamId);
            this.isOpenSuccess = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.cleanupStream(this.streamId);
            this.isClosed = true;
        }
    }

    public void moveToNextPartitionIfPossible(long endedStreamId, @Nullable BiConsumer<Long, Integer> requiredSegmentIdConsumer, boolean sync) {
        logger.debug("MoveToNextPartitionIfPossible in this: {},  endedStreamId: {}, currentLocationIndex: {}, currentSteamId: {}, locationsLength: {}.", new Object[]{this, endedStreamId, this.currentLocationIndex.get(), this.streamId, this.locations.length});
        if (this.currentLocationIndex.get() > 0) {
            logger.debug("Get end streamId {}", (Object)endedStreamId);
            this.cleanupStream(endedStreamId);
        }
        if (this.currentLocationIndex.get() < this.locations.length) {
            if (sync) {
                try {
                    this.openStreamInternal(requiredSegmentIdConsumer, true);
                    logger.debug("MoveToNextPartitionIfPossible after openStream this: {},  endedStreamId: {}, currentLocationIndex: {}, currentSteamId: {}, locationsLength: {}.", new Object[]{this, endedStreamId, this.currentLocationIndex.get(), this.streamId, this.locations.length});
                }
                catch (Exception e) {
                    logger.warn("Failed to open stream and report to flink framework. ", (Throwable)e);
                    this.messageConsumer.accept(new TransportableError(0L, e));
                }
            } else {
                CompletableFuture.runAsync(() -> {
                    try {
                        this.openStreamInternal(requiredSegmentIdConsumer, false);
                    }
                    catch (IOException | InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }, this.openStreamThreadPool).whenComplete((result, throwable) -> {
                    if (throwable == null) {
                        logger.debug("MoveToNextPartitionIfPossible after openStream this: {},  endedStreamId: {}, currentLocationIndex: {}, currentSteamId: {}, locationsLength: {}.", new Object[]{this, endedStreamId, this.currentLocationIndex.get(), this.streamId, this.locations.length});
                    } else {
                        logger.warn("Failed to open stream and report to flink framework. ", throwable);
                        this.messageConsumer.accept(new TransportableError(0L, (Throwable)throwable));
                    }
                });
            }
        }
    }

    private void openStreamInternal(final @Nullable BiConsumer<Long, Integer> requiredSegmentIdConsumer, boolean sync) throws IOException, InterruptedException {
        this.client = this.clientFactory.createClientWithRetry(this.locations[this.currentLocationIndex.get()].getHost(), this.locations[this.currentLocationIndex.get()].getFetchPort());
        final String fileName = this.locations[this.currentLocationIndex.getAndIncrement()].getFileName();
        TransportMessage openStream = new TransportMessage(MessageType.OPEN_STREAM, PbOpenStream.newBuilder().setShuffleKey(this.shuffleKey).setFileName(fileName).setStartIndex(this.subIndexStart).setEndIndex(this.subIndexEnd).setInitialCredit(this.initialCredit).build().toByteArray());
        RpcResponseCallback rpcResponseCallback = new RpcResponseCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(ByteBuffer response) {
                try {
                    PbStreamHandler pbStreamHandler = (PbStreamHandler)TransportMessage.fromByteBuffer(response).getParsedPayload();
                    CelebornBufferStream.this.streamId = pbStreamHandler.getStreamId();
                    Object object = CelebornBufferStream.this.lock;
                    synchronized (object) {
                        if (!CelebornBufferStream.this.isClosed) {
                            CelebornBufferStream.this.clientFactory.registerSupplier(CelebornBufferStream.this.streamId, CelebornBufferStream.this.bufferSupplier);
                            CelebornBufferStream.this.mapShuffleClient.getReadClientHandler().registerHandler(CelebornBufferStream.this.streamId, CelebornBufferStream.this.messageConsumer, CelebornBufferStream.this.client);
                            CelebornBufferStream.this.isOpenSuccess = true;
                            if (requiredSegmentIdConsumer != null) {
                                for (int subPartitionId = CelebornBufferStream.this.subIndexStart; subPartitionId <= CelebornBufferStream.this.subIndexEnd; ++subPartitionId) {
                                    requiredSegmentIdConsumer.accept(CelebornBufferStream.this.streamId, subPartitionId);
                                }
                            }
                            logger.debug("open stream success from remote:{}, stream id:{}, fileName: {}", new Object[]{CelebornBufferStream.this.client.getSocketAddress(), CelebornBufferStream.this.streamId, fileName});
                        } else {
                            logger.debug("open stream success from remote:{}, but stream reader is already closed, stream id:{}, fileName: {}", new Object[]{CelebornBufferStream.this.client.getSocketAddress(), CelebornBufferStream.this.streamId, fileName});
                            CelebornBufferStream.this.closeStream(CelebornBufferStream.this.streamId);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Open file {} stream for {} error from {}", new Object[]{fileName, CelebornBufferStream.this.shuffleKey, NettyUtils.getRemoteAddress(CelebornBufferStream.this.client.getChannel())});
                    CelebornBufferStream.this.messageConsumer.accept(new TransportableError(CelebornBufferStream.this.streamId, e));
                }
            }

            @Override
            public void onFailure(Throwable e) {
                logger.error("Open file {} stream for {} error from {}", new Object[]{fileName, CelebornBufferStream.this.shuffleKey, NettyUtils.getRemoteAddress(CelebornBufferStream.this.client.getChannel())});
                CelebornBufferStream.this.messageConsumer.accept(new TransportableError(CelebornBufferStream.this.streamId, e));
            }
        };
        if (sync) {
            this.client.sendRpcSync(openStream.toByteBuffer(), rpcResponseCallback, this.pushDataTimeoutMs);
        } else {
            this.client.sendRpc(openStream.toByteBuffer(), rpcResponseCallback);
        }
    }

    public TransportClient getClient() {
        return this.client;
    }

    public boolean isOpened() {
        return this.isOpenSuccess;
    }
}

