/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.http;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URL;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.server.common.http.HttpUtils;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.LambdaDeserialize;

public final class HttpUtils$
implements Logging {
    public static HttpUtils$ MODULE$;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    static {
        new HttpUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        HttpUtils$ httpUtils$ = this;
        synchronized (httpUtils$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public <T> ServletContextHandler createServletHandler(String path, HttpUtils.ServletParams<T> servletParams) {
        return this.createServletHandler(path, this.createServlet(servletParams));
    }

    private <T> HttpServlet createServlet(HttpUtils.ServletParams<T> servletParams) {
        return new HttpServlet(servletParams){
            private final HttpUtils.ServletParams servletParams$1;

            public void doGet(HttpServletRequest request, HttpServletResponse response) {
                try {
                    response.setContentType(new StringOps(Predef$.MODULE$.augmentString("%s;charset=utf-8")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.servletParams$1.contentType()})));
                    response.setStatus(200);
                    Object result = this.servletParams$1.responder().apply((Object)request);
                    response.getWriter().print((String)this.servletParams$1.extractFn().apply(result));
                }
                catch (IllegalArgumentException e) {
                    response.sendError(400, e.getMessage());
                }
                catch (Exception e) {
                    HttpUtils$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("GET ").append(request.getRequestURI()).append(" failed: ").append(e).toString(), e);
                    throw e;
                }
            }

            public void doTrace(HttpServletRequest req, HttpServletResponse res) {
                res.sendError(405);
            }
            {
                this.servletParams$1 = servletParams$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$doGet$1(javax.servlet.http.HttpServletRequest java.lang.Exception )}, serializedLambda);
            }
        };
    }

    public ServletContextHandler createStaticHandler(String resourceBase, String contextPath) {
        ServletHolder holder = new ServletHolder(DefaultServlet.class);
        Option option = Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader().getResource(resourceBase));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new CelebornException(new StringBuilder(41).append("Could not find resource path for Web UI: ").append(resourceBase).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        URL res = (URL)some.value();
        holder.setInitParameter("resourceBase", res.toString());
        return this.createContextHandler(contextPath, holder);
    }

    public ServletContextHandler createServletHandler(String contextPath, HttpServlet servlet) {
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        return this.createContextHandler(contextPath, holder);
    }

    public ServletContextHandler createRedirectHandler(String src, String dest) {
        HttpServlet redirectedServlet = new HttpServlet(dest){
            private final String dest$1;

            private void doReq(HttpServletRequest req, HttpServletResponse resp) {
                String newURL = new URL(new URL(req.getRequestURL().toString()), this.dest$1).toString();
                resp.sendRedirect(newURL);
            }

            public void doGet(HttpServletRequest req, HttpServletResponse resp) {
                this.doReq(req, resp);
            }

            public void doPut(HttpServletRequest req, HttpServletResponse resp) {
                this.doReq(req, resp);
            }

            public void doPost(HttpServletRequest req, HttpServletResponse resp) {
                this.doReq(req, resp);
            }

            public void doDelete(HttpServletRequest req, HttpServletResponse resp) {
                this.doReq(req, resp);
            }

            public void doTrace(HttpServletRequest req, HttpServletResponse resp) {
                resp.sendError(405);
            }
            {
                this.dest$1 = dest$1;
            }
        };
        return this.createServletHandler(src, redirectedServlet);
    }

    public ServletContextHandler createContextHandler(String contextPath, ServletHolder servletHolder) {
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setContextPath(contextPath);
        contextHandler.addServlet(servletHolder, "/");
        contextHandler.setAllowNullPathInfo(true);
        return contextHandler;
    }

    private HttpUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

