/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import java.util.function.IntToDoubleFunction;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.GeometricSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;
import org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import org.apache.commons.statistics.distribution.ArgumentUtils;
import org.apache.commons.statistics.distribution.DiscreteDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public final class GeometricDistribution
extends AbstractDiscreteDistribution {
    private static final double HALF = 0.5;
    private final double probabilityOfSuccess;
    private final double logProbabilityOfSuccess;
    private final double log1mProbabilityOfSuccess;
    private final double sf0;
    private final IntToDoubleFunction pmf;

    private GeometricDistribution(double p) {
        this.probabilityOfSuccess = p;
        this.logProbabilityOfSuccess = Math.log(p);
        this.log1mProbabilityOfSuccess = Math.log1p(-p);
        this.sf0 = 1.0 - p;
        this.pmf = p >= 0.5 ? x -> Math.pow(this.sf0, x) * this.probabilityOfSuccess : x -> Math.exp(this.log1mProbabilityOfSuccess * (double)x) * this.probabilityOfSuccess;
    }

    public static GeometricDistribution of(double p) {
        if (p <= 0.0 || p > 1.0) {
            throw new DistributionException("Not a non-zero probability: %s is out of range (0, 1]", p);
        }
        return new GeometricDistribution(p);
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int x) {
        if (x <= 0) {
            return x == 0 ? this.probabilityOfSuccess : 0.0;
        }
        return this.pmf.applyAsDouble(x);
    }

    @Override
    public double logProbability(int x) {
        if (x <= 0) {
            return x == 0 ? this.logProbabilityOfSuccess : Double.NEGATIVE_INFINITY;
        }
        return (double)x * this.log1mProbabilityOfSuccess + this.logProbabilityOfSuccess;
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x <= 0) {
            return x == 0 ? this.probabilityOfSuccess : 0.0;
        }
        return -Math.expm1(this.log1mProbabilityOfSuccess * ((double)x + 1.0));
    }

    @Override
    public double survivalProbability(int x) {
        if (x <= 0) {
            return x == 0 ? this.sf0 : 1.0;
        }
        return Math.exp(this.log1mProbabilityOfSuccess * ((double)x + 1.0));
    }

    @Override
    public int inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 1.0) {
            return this.getSupportUpperBound();
        }
        if (p <= this.probabilityOfSuccess) {
            return 0;
        }
        int x = (int)(Math.ceil(Math.log1p(-p) / this.log1mProbabilityOfSuccess) - 1.0);
        if (this.cumulativeProbability(x - 1) >= p) {
            --x;
        } else if (this.cumulativeProbability(x) < p && x < Integer.MAX_VALUE) {
            ++x;
        }
        return x;
    }

    @Override
    public int inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 0.0) {
            return this.getSupportUpperBound();
        }
        if (p >= this.sf0) {
            return 0;
        }
        int x = (int)(Math.ceil(Math.log(p) / this.log1mProbabilityOfSuccess) - 1.0);
        if (this.survivalProbability(x - 1) <= p) {
            --x;
        } else if (this.survivalProbability(x) > p && x < Integer.MAX_VALUE) {
            ++x;
        }
        return x;
    }

    @Override
    public double getMean() {
        return (1.0 - this.probabilityOfSuccess) / this.probabilityOfSuccess;
    }

    @Override
    public double getVariance() {
        return (1.0 - this.probabilityOfSuccess) / (this.probabilityOfSuccess * this.probabilityOfSuccess);
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return this.probabilityOfSuccess < 1.0 ? Integer.MAX_VALUE : 0;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((SharedStateDiscreteSampler)GeometricSampler.of((UniformRandomProvider)rng, (double)this.probabilityOfSuccess)).sample();
    }
}

