/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import java.math.BigInteger;
import org.apache.daffodil.runtime1.dpath.InvalidPrimitiveDataException;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.PrimProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.ToBriefXMLImpl;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import org.apache.daffodil.runtime1.processors.parsers.TextPrimParser;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class ConvertNonBaseTenTextNumberParser
implements ToBriefXMLImpl,
Processor,
PrimProcessor,
Parser,
TextPrimParser {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ConvertNonBaseTenTextNumberParser.class.getDeclaredField("parserName$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConvertNonBaseTenTextNumberParser.class.getDeclaredField("org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1"));
    private volatile Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
    private boolean isInitialized;
    private volatile Object parserName$lzy1;
    private final ElementRuntimeData context;
    private final int base;
    private final NodeInfo.PrimType.PrimNumeric primNumeric;

    public ConvertNonBaseTenTextNumberParser(ElementRuntimeData context, int base) {
        this.context = context;
        this.base = base;
        ToBriefXMLImpl.$init$(this);
        Processor.$init$(this);
        Parser.$init$(this);
        this.primNumeric = (NodeInfo.PrimType.PrimNumeric)context.optPrimType().get();
    }

    @Override
    public String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_() {
        Object object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1();
    }

    private Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ToBriefXMLImpl.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    @Override
    public String parserName() {
        Object object = this.parserName$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.parserName$lzyINIT1();
    }

    private Object parserName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.parserName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = Parser.parserName$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parserName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public ElementRuntimeData context() {
        return this.context;
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    @Override
    public final void parse(PState state) {
        Number number;
        BigInteger bigInteger;
        String baseStr;
        DISimple node = state.simpleElement();
        String string = baseStr = node.dataValueAsString();
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.PE(state, "Unable to parse %s from empty string", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((NodeInfo.Kind)this.context().optPrimType().get()).globalQName()}));
            return;
        }
        char firstChar = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(baseStr), 0);
        if (firstChar == '-' || firstChar == '+') {
            this.PE(state, "Unable to parse %s from base-%d text with leading sign: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((NodeInfo.Kind)this.context().optPrimType().get()).globalQName(), BoxesRunTime.boxToInteger((int)this.base), baseStr}));
            return;
        }
        try {
            bigInteger = new BigInteger(baseStr, this.base);
        }
        catch (NumberFormatException e) {
            this.PE(state, "Unable to parse %s from base-%d text due to invalid characters: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((NodeInfo.Kind)this.context().optPrimType().get()).globalQName(), BoxesRunTime.boxToInteger((int)this.base), baseStr}));
            return;
        }
        BigInteger bi = bigInteger;
        try {
            number = this.primNumeric.fromNumber(bi);
        }
        catch (InvalidPrimitiveDataException e) {
            this.PE(state, "%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()}));
            return;
        }
        Number num = number;
        node.overwriteDataValue(num);
    }
}

