<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# sqlparser-rs 0.59.0 Changelog

This release consists of 59 commits from 22 contributors. See credits at the end of this changelog for more information.

**Implemented enhancements:**

- feat: support export data for bigquery [#1976](https://github.com/apache/datafusion-sqlparser-rs/pull/1976) (chenkovsky)
- feat: support multi value columns and aliases in unpivot [#1969](https://github.com/apache/datafusion-sqlparser-rs/pull/1969) (chenkovsky)
- feat: Include end token in `ALTER TABLE` statement [#1999](https://github.com/apache/datafusion-sqlparser-rs/pull/1999) (IndexSeek)
- feat: support multiple value for pivot [#1970](https://github.com/apache/datafusion-sqlparser-rs/pull/1970) (chenkovsky)
- feat: Add `ALTER SCHEMA` support [#1980](https://github.com/apache/datafusion-sqlparser-rs/pull/1980) (chenkovsky)
- feat: MERGE statements: add RETURNING and OUTPUT without INTO [#2011](https://github.com/apache/datafusion-sqlparser-rs/pull/2011) (lovasoa)
- feat: support postgres alter schema [#2038](https://github.com/apache/datafusion-sqlparser-rs/pull/2038) (chenkovsky)

**Fixed bugs:**

- fix: begin statement for bigquery [#1975](https://github.com/apache/datafusion-sqlparser-rs/pull/1975) (chenkovsky)
- fix: update DuckDB and ClickHouse documentation links [#1978](https://github.com/apache/datafusion-sqlparser-rs/pull/1978) (IndexSeek)

**Other:**

- MySQL: Support `EXPLAIN ANALYZE` format variants [#1945](https://github.com/apache/datafusion-sqlparser-rs/pull/1945) (yoavcloud)
- Add support for `NOT NULL` and `NOTNULL` expressions [#1927](https://github.com/apache/datafusion-sqlparser-rs/pull/1927) (ryanschneider)
- Snowflake: Support `CLONE` option in `CREATE DATABASE/SCHEMA` statements [#1958](https://github.com/apache/datafusion-sqlparser-rs/pull/1958) (yoavcloud)
- Add support for `GRANT DROP` statement [#1959](https://github.com/apache/datafusion-sqlparser-rs/pull/1959) (yoavcloud)
- Snowflake: Add support for `CREATE USER` [#1950](https://github.com/apache/datafusion-sqlparser-rs/pull/1950) (yoavcloud)
- Postgres: Support parenthesized `SET` options for `ALTER TABLE` [#1947](https://github.com/apache/datafusion-sqlparser-rs/pull/1947) (achristmascarl)
- Snowflake: Support IDENTIFIER for GRANT ROLE [#1957](https://github.com/apache/datafusion-sqlparser-rs/pull/1957) (yoavcloud)
- Snowflake: Numeric prefix for stage name part [#1966](https://github.com/apache/datafusion-sqlparser-rs/pull/1966) (yoavcloud)
- Snowflake: Support `GRANT CREATE SCHEMA` `GRANT .. ON ALL FUNCTIONS IN SCHEMA` [#1964](https://github.com/apache/datafusion-sqlparser-rs/pull/1964) (yoavcloud)
- Snowflake: DROP STREAM [#1973](https://github.com/apache/datafusion-sqlparser-rs/pull/1973) (yoavcloud)
- Add ODBC escape syntax support for time expressions [#1953](https://github.com/apache/datafusion-sqlparser-rs/pull/1953) (etgarperets)
- Add support for `SHOW CHARSET` [#1974](https://github.com/apache/datafusion-sqlparser-rs/pull/1974) (etgarperets)
- Snowflake: Support `CREATE VIEW myview IF NOT EXISTS` [#1961](https://github.com/apache/datafusion-sqlparser-rs/pull/1961) (etgarperets)
- Update criterion requirement from 0.6 to 0.7 in /sqlparser_bench [#1981](https://github.com/apache/datafusion-sqlparser-rs/pull/1981) (dependabot[bot])
- Snowflake: Improve support for reserved keywords for table factor [#1942](https://github.com/apache/datafusion-sqlparser-rs/pull/1942) (yoavcloud)
- MySQL: Allow optional `SIGNED` suffix on integer data types [#1985](https://github.com/apache/datafusion-sqlparser-rs/pull/1985) (mvzink)
- Fix placeholder spans [#1979](https://github.com/apache/datafusion-sqlparser-rs/pull/1979) (xitep)
- Snowflake create database [#1939](https://github.com/apache/datafusion-sqlparser-rs/pull/1939) (osipovartem)
- Postgres: Support `INTERVAL` data type options [#1984](https://github.com/apache/datafusion-sqlparser-rs/pull/1984) (mvzink)
- MySQL: Support comma-separated `CREATE TABLE` options [#1989](https://github.com/apache/datafusion-sqlparser-rs/pull/1989) (mvzink)
- MySQL: Support `ALTER TABLE RENAME AS` [#1965](https://github.com/apache/datafusion-sqlparser-rs/pull/1965) (altmannmarcelo)
- Improve MySQL `CREATE TRIGGER` parsing [#1998](https://github.com/apache/datafusion-sqlparser-rs/pull/1998) (mvzink)
- Snowflake - support table function in table factor (regression) [#1996](https://github.com/apache/datafusion-sqlparser-rs/pull/1996) (tomershaniii)
- Improve MySQL option parsing in index definitions [#1997](https://github.com/apache/datafusion-sqlparser-rs/pull/1997) (mvzink)
- Add support for `UPDATE ... LIMIT ...` [#1991](https://github.com/apache/datafusion-sqlparser-rs/pull/1991) (xtuc)
- Postgres: enhance NUMERIC/DECIMAL parsing to support negative scale [#1990](https://github.com/apache/datafusion-sqlparser-rs/pull/1990) (IndexSeek)
- Fix column definition `COLLATE` parsing [#1986](https://github.com/apache/datafusion-sqlparser-rs/pull/1986) (mvzink)
- Redshift: CREATE TABLE ... (LIKE ..) [#1967](https://github.com/apache/datafusion-sqlparser-rs/pull/1967) (yoavcloud)
- Add drop behavior to `DROP PRIMARY/FOREIGN KEY` [#2002](https://github.com/apache/datafusion-sqlparser-rs/pull/2002) (yoavcloud)
- Redshift: Add support for IAM_ROLE and IGNOREHEADER COPY options [#1968](https://github.com/apache/datafusion-sqlparser-rs/pull/1968) (yoavcloud)
- Snowflake: Add support for `CREATE DYNAMIC TABLE` [#1960](https://github.com/apache/datafusion-sqlparser-rs/pull/1960) (yoavcloud)
- Add support for VACUUM in Redshift [#2005](https://github.com/apache/datafusion-sqlparser-rs/pull/2005) (yoavcloud)
- Add support for `SEMANTIC_VIEW` table factor [#2009](https://github.com/apache/datafusion-sqlparser-rs/pull/2009) (bombsimon)
- Redshift: Add more copy options [#2008](https://github.com/apache/datafusion-sqlparser-rs/pull/2008) (yoavcloud)
- `GenericDialect`: Support pipe operator [#2012](https://github.com/apache/datafusion-sqlparser-rs/pull/2012) (simonvandel)
- Add SECURE keyword for views in Snowflake [#2004](https://github.com/apache/datafusion-sqlparser-rs/pull/2004) (Vedin)
- Add support for PostgreSQL JSON function 'RETURNING' clauses [#2001](https://github.com/apache/datafusion-sqlparser-rs/pull/2001) (adamchainz)
- Snowflake: Minus char in stage name [#2014](https://github.com/apache/datafusion-sqlparser-rs/pull/2014) (yoavcloud)
- Support wildcard metrics for `SEMANTIC_VIEW` [#2016](https://github.com/apache/datafusion-sqlparser-rs/pull/2016) (bombsimon)
- Allow wilrdacrd for all `SEMANTIC_VIEW` types [#2017](https://github.com/apache/datafusion-sqlparser-rs/pull/2017) (bombsimon)
- Redshift: UNLOAD [#2013](https://github.com/apache/datafusion-sqlparser-rs/pull/2013) (yoavcloud)
- Add support for string literal concatenation [#2003](https://github.com/apache/datafusion-sqlparser-rs/pull/2003) (etgarperets)
- Enable merge queue in sqlparser-rs [#2007](https://github.com/apache/datafusion-sqlparser-rs/pull/2007) (blaginin)
- Merge Queue Test [#2019](https://github.com/apache/datafusion-sqlparser-rs/pull/2019) (blaginin)
- Added derive trait `Copy` to `OrderByOptions` struct [#2021](https://github.com/apache/datafusion-sqlparser-rs/pull/2021) (LucaCappelletti94)
- Moved `CreateTrigger` and `DropTrigger` out of `Statement` enum [#2026](https://github.com/apache/datafusion-sqlparser-rs/pull/2026) (LucaCappelletti94)
- MySQL:  Support `CROSS JOIN` constraint [#2025](https://github.com/apache/datafusion-sqlparser-rs/pull/2025) (rs-sac)
- Implemented the `From` method for all clear variants in Statement [#2028](https://github.com/apache/datafusion-sqlparser-rs/pull/2028) (LucaCappelletti94)
- DuckDB: Allow quoted date parts in EXTRACT [#2030](https://github.com/apache/datafusion-sqlparser-rs/pull/2030) (ryanschneider)
- MySQL: Add support for unsigned numeric types [#2031](https://github.com/apache/datafusion-sqlparser-rs/pull/2031) (MohamedAbdeen21)

## Credits

Thank you to everyone who contributed to this release. Here is a breakdown of commits (PRs merged) per contributor.

```
    17	Yoav Cohen
     6	Chen Chongchen
     6	Michael Victor Zink
     4	etgarperets
     3	Luca Cappelletti
     3	Simon Sawert
     3	Tyler White
     2	Dmitrii Blaginin
     2	Ryan Schneider
     1	Adam Johnson
     1	Artem Osipov
     1	Denys Tsomenko
     1	Marcelo Altmann
     1	Mohamed Abdeen
     1	Ophir LOJKINE
     1	Sidney Cammeresi
     1	Simon Vandel Sillesen
     1	Sven Sauleau
     1	carl
     1	dependabot[bot]
     1	tomershaniii
     1	xitep
```

Thank you also to everyone who contributed in other ways such as filing issues, reviewing PRs, and providing feedback on this release.

