/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.ComparableSubject;
import com.google.common.truth.FailureStrategy;
import java.math.BigDecimal;
import javax.annotation.Nullable;

public final class BigDecimalSubject
extends ComparableSubject<BigDecimalSubject, BigDecimal> {
    BigDecimalSubject(FailureStrategy failureStrategy, @Nullable BigDecimal subject) {
        super(failureStrategy, subject);
    }

    public void isEqualToIgnoringScale(BigDecimal expected) {
        this.compareValues(expected);
    }

    public void isEqualToIgnoringScale(String expected) {
        this.compareValues(new BigDecimal(expected));
    }

    public void isEqualToIgnoringScale(long expected) {
        this.compareValues(new BigDecimal(expected));
    }

    @Override
    public void isEqualTo(@Nullable Object expected) {
        super.isEqualTo(expected);
    }

    @Override
    public void isEquivalentAccordingToCompareTo(BigDecimal expected) {
        this.compareValues(expected);
    }

    private void compareValues(BigDecimal expected) {
        if (((BigDecimal)this.actual()).compareTo(expected) != 0) {
            this.failWithRawMessage("%s should have had the same value as <%s> (scale is ignored)", this.actualAsString(), expected);
        }
    }
}

