/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor.registry;

import com.navercorp.pinpoint.bootstrap.interceptor.Interceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.DefaultLocker;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.EmptyRegistryAdaptor;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.InterceptorRegistryAdaptor;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.Locker;
import java.util.Objects;

public final class InterceptorRegistry {
    private static final Locker LOCK = new DefaultLocker();
    private static InterceptorRegistryAdaptor REGISTRY = EmptyRegistryAdaptor.EMPTY;

    public static void bind(InterceptorRegistryAdaptor interceptorRegistryAdaptor, Object lock) {
        Objects.requireNonNull(interceptorRegistryAdaptor, "interceptorRegistryAdaptor");
        if (!LOCK.lock(lock)) {
            throw new IllegalStateException("bind failed. lock=" + lock + " current=" + LOCK.getLock());
        }
        REGISTRY = interceptorRegistryAdaptor;
    }

    public static void unbind(Object lock) {
        if (!LOCK.unlock(lock)) {
            throw new IllegalStateException("unbind failed. lock=" + lock + " current=" + LOCK.getLock());
        }
        REGISTRY = EmptyRegistryAdaptor.EMPTY;
    }

    public static Interceptor getInterceptor(int key) {
        return REGISTRY.getInterceptor(key);
    }
}

