/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.uri;

import com.navercorp.pinpoint.bootstrap.plugin.uri.UriExtractor;
import com.navercorp.pinpoint.common.trace.UriExtractorType;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import java.util.List;

public class UriExtractorChain<T>
implements UriExtractor<T> {
    private final List<UriExtractor<T>> uriExtractorList;

    public UriExtractorChain(List<UriExtractor<T>> uriExtractorList) {
        if (CollectionUtils.isEmpty(uriExtractorList)) {
            throw new IllegalArgumentException("uriExtractorList may not be empty");
        }
        this.uriExtractorList = uriExtractorList;
    }

    @Override
    public UriExtractorType getExtractorType() {
        return this.uriExtractorList.get(0).getExtractorType();
    }

    @Override
    public String getUri(T target, String rawUrl) {
        for (UriExtractor<T> uriExtractor : this.uriExtractorList) {
            String uri = uriExtractor.getUri(target, rawUrl);
            if (uri == null) continue;
            return uri;
        }
        for (String oftenUsedUrl : DEFAULT_OFTEN_USED_URL) {
            if (!oftenUsedUrl.equals(rawUrl)) continue;
            return oftenUsedUrl;
        }
        return "/NOT_FOUND_URI";
    }
}

