/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.EventMeshConsumer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsubscribeProcessor {
    private static final Logger log = LoggerFactory.getLogger(UnsubscribeProcessor.class);
    private final EventMeshGrpcServer eventMeshGrpcServer;

    public UnsubscribeProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }

    public void process(CloudEvent subscription, EventEmitter<CloudEvent> emitter) throws Exception {
        if (!ServiceUtils.validateCloudEventAttributes(subscription)) {
            ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_PROTOCOL_HEADER_ERR, emitter);
            return;
        }
        if (!ServiceUtils.validateSubscription(null, subscription)) {
            ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_PROTOCOL_BODY_ERR, emitter);
            return;
        }
        ConsumerManager consumerManager = this.eventMeshGrpcServer.getConsumerManager();
        String consumerGroup = EventMeshCloudEventUtils.getConsumerGroup((CloudEvent)subscription);
        String url = EventMeshCloudEventUtils.getURL((CloudEvent)subscription);
        List subscriptionItems = (List)JsonUtils.parseTypeReferenceObject((String)subscription.getTextData(), (TypeReference)new TypeReference<List<SubscriptionItem>>(){});
        String env = EventMeshCloudEventUtils.getEnv((CloudEvent)subscription);
        String idc = EventMeshCloudEventUtils.getIdc((CloudEvent)subscription);
        String sys = EventMeshCloudEventUtils.getSys((CloudEvent)subscription);
        String ip = EventMeshCloudEventUtils.getIp((CloudEvent)subscription);
        String pid = EventMeshCloudEventUtils.getPid((CloudEvent)subscription);
        LinkedList<ConsumerGroupClient> removeClients = new LinkedList<ConsumerGroupClient>();
        for (SubscriptionItem item : subscriptionItems) {
            ConsumerGroupClient newClient = ConsumerGroupClient.builder().env(env).idc(idc).sys(sys).ip(ip).pid(pid).consumerGroup(consumerGroup).topic(item.getTopic()).subscriptionMode(item.getMode()).url(url).lastUpTime(new Date()).build();
            removeClients.add(newClient);
        }
        for (ConsumerGroupClient client : removeClients) {
            consumerManager.deregisterClient(client);
        }
        EventMeshConsumer eventMeshConsumer = consumerManager.getEventMeshConsumer(consumerGroup);
        boolean requireRestart = false;
        for (ConsumerGroupClient client : removeClients) {
            if (!eventMeshConsumer.deregisterClient(client)) continue;
            requireRestart = true;
        }
        if (requireRestart) {
            log.info("ConsumerGroup {} topic info changed, restart EventMesh Consumer", (Object)consumerGroup);
            consumerManager.restartEventMeshConsumer(consumerGroup);
        } else {
            log.warn("EventMesh consumer [{}] didn't restart.", (Object)consumerGroup);
        }
        ServiceUtils.sendResponseCompleted(StatusCode.SUCCESS, "unsubscribe success", emitter);
    }
}

