/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.auth.AuthService;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookUtil {
    private static final Logger log = LoggerFactory.getLogger(WebhookUtil.class);
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String REQUEST_ORIGIN_HEADER = "WebHook-Request-Origin";
    private static final String ALLOWED_ORIGIN_HEADER = "WebHook-Allowed-Origin";
    private static final Map<String, AuthService> AUTH_SERVICES_MAP = new ConcurrentHashMap<String, AuthService>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean obtainDeliveryAgreement(CloseableHttpClient httpClient, String targetUrl, String requestOrigin) {
        if (log.isInfoEnabled()) {
            log.info("obtain webhook delivery agreement for url: {}", (Object)targetUrl);
        }
        HttpOptions builder = new HttpOptions(targetUrl);
        builder.addHeader(REQUEST_ORIGIN_HEADER, requestOrigin);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)builder);){
            String allowedOrigin = response.getLastHeader(ALLOWED_ORIGIN_HEADER).getValue();
            boolean bl = StringUtils.isEmpty((CharSequence)allowedOrigin) || "*".equals(allowedOrigin) || allowedOrigin.equalsIgnoreCase(requestOrigin);
            return bl;
        }
        catch (Exception e) {
            if (!log.isErrorEnabled()) return true;
            log.error("HTTP Options Method is not supported at the Delivery Target: {}, unable to obtain the webhook delivery agreement.", (Object)targetUrl);
            return true;
        }
    }

    public static void setWebhookHeaders(HttpPost builder, String contentType, String requestOrigin, String urlAuthType) {
        builder.setHeader(CONTENT_TYPE_HEADER, contentType);
        builder.setHeader(REQUEST_ORIGIN_HEADER, requestOrigin);
        Map<String, String> authParam = WebhookUtil.getHttpAuthParam(urlAuthType);
        if (authParam != null) {
            authParam.forEach((k, v) -> builder.addHeader((Header)new BasicHeader(k, v)));
        }
    }

    private static Map<String, String> getHttpAuthParam(String authType) {
        if (StringUtils.isEmpty((CharSequence)authType)) {
            return new HashMap<String, String>();
        }
        AuthService authService = WebhookUtil.getHttpAuthPlugin(authType);
        return authService != null ? authService.getAuthParams() : null;
    }

    private static AuthService getHttpAuthPlugin(String pluginType) {
        if (AUTH_SERVICES_MAP.containsKey(pluginType)) {
            return AUTH_SERVICES_MAP.get(pluginType);
        }
        AuthService authService = (AuthService)EventMeshExtensionFactory.getExtension(AuthService.class, (String)pluginType);
        Objects.requireNonNull(authService, "authService can not be null");
        authService.init();
        AUTH_SERVICES_MAP.put(pluginType, authService);
        return authService;
    }
}

