/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.StringValue;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.IntStringValue;
import com.navercorp.pinpoint.grpc.trace.PAcceptEvent;
import com.navercorp.pinpoint.grpc.trace.PAnnotation;
import com.navercorp.pinpoint.grpc.trace.PAnnotationValue;
import com.navercorp.pinpoint.grpc.trace.PIntStringValue;
import com.navercorp.pinpoint.grpc.trace.PLocalAsyncId;
import com.navercorp.pinpoint.grpc.trace.PMessageEvent;
import com.navercorp.pinpoint.grpc.trace.PNextEvent;
import com.navercorp.pinpoint.grpc.trace.PParentInfo;
import com.navercorp.pinpoint.grpc.trace.PSpan;
import com.navercorp.pinpoint.grpc.trace.PSpanChunk;
import com.navercorp.pinpoint.grpc.trace.PSpanEvent;
import com.navercorp.pinpoint.grpc.trace.PTransactionId;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.AsyncId;
import com.navercorp.pinpoint.profiler.context.AsyncSpanChunk;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.compress.SpanProcessor;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationValueMapper;
import com.navercorp.pinpoint.profiler.context.id.Shared;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GrpcSpanMessageConverter
implements MessageConverter<SpanType, GeneratedMessageV3> {
    private final String agentId;
    private final short applicationServiceType;
    private final SpanProcessor<PSpan.Builder, PSpanChunk.Builder> spanProcessor;
    private final GrpcAnnotationValueMapper grpcAnnotationValueMapper = new GrpcAnnotationValueMapper();
    private final PSpanEvent.Builder pSpanEventBuilder = PSpanEvent.newBuilder();
    private final PAnnotation.Builder pAnnotationBuilder = PAnnotation.newBuilder();

    public GrpcSpanMessageConverter(String agentId, short applicationServiceType, SpanProcessor<PSpan.Builder, PSpanChunk.Builder> spanProcessor) {
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.applicationServiceType = applicationServiceType;
        this.spanProcessor = Objects.requireNonNull(spanProcessor, "spanProcessor");
    }

    @Override
    public GeneratedMessageV3 toMessage(SpanType message) {
        if (message instanceof SpanChunk) {
            SpanChunk spanChunk = (SpanChunk)message;
            PSpanChunk pSpanChunk = this.buildPSpanChunk(spanChunk);
            return pSpanChunk;
        }
        if (message instanceof Span) {
            Span span = (Span)message;
            return this.buildPSpan(span);
        }
        return null;
    }

    @VisibleForTesting
    PSpan buildPSpan(Span span) {
        PSpan.Builder pSpan = PSpan.newBuilder();
        pSpan.setVersion(1);
        pSpan.setApplicationServiceType((int)this.applicationServiceType);
        TraceRoot traceRoot = span.getTraceRoot();
        TraceId traceId = traceRoot.getTraceId();
        PTransactionId transactionId = this.newTransactionId(traceId);
        pSpan.setTransactionId(transactionId);
        pSpan.setSpanId(traceId.getSpanId());
        pSpan.setParentSpanId(traceId.getParentSpanId());
        pSpan.setStartTime(span.getStartTime());
        pSpan.setElapsed(span.getElapsedTime());
        pSpan.setServiceType((int)span.getServiceType());
        PAcceptEvent pAcceptEvent = this.newAcceptEvent(span);
        pSpan.setAcceptEvent(pAcceptEvent);
        pSpan.setFlag((int)traceId.getFlags());
        Shared shared = span.getTraceRoot().getShared();
        pSpan.setErr(shared.getErrorCode());
        pSpan.setApiId(span.getApiId());
        IntStringValue exceptionInfo = span.getExceptionInfo();
        if (exceptionInfo != null) {
            PIntStringValue pIntStringValue = this.buildPIntStringValue(exceptionInfo);
            pSpan.setExceptionInfo(pIntStringValue);
        }
        pSpan.setLoggingTransactionInfo((int)shared.getLoggingInfo());
        List<Annotation<?>> annotations = span.getAnnotations();
        if (CollectionUtils.hasLength(annotations)) {
            List<PAnnotation> tAnnotations = this.buildPAnnotation(annotations);
            pSpan.addAllAnnotation(tAnnotations);
        }
        this.spanProcessor.preProcess(span, pSpan);
        List<SpanEvent> spanEventList = span.getSpanEventList();
        if (CollectionUtils.hasLength(spanEventList)) {
            List<PSpanEvent> pSpanEvents = this.buildPSpanEventList(spanEventList);
            pSpan.addAllSpanEvent(pSpanEvents);
        }
        this.spanProcessor.postProcess(span, pSpan);
        return pSpan.build();
    }

    private PTransactionId newTransactionId(TraceId traceId) {
        if (this.isCompressedType(traceId)) {
            PTransactionId.Builder builder = PTransactionId.newBuilder();
            builder.setAgentStartTime(traceId.getAgentStartTime());
            builder.setSequence(traceId.getTransactionSequence());
            return builder.build();
        }
        PTransactionId.Builder builder = PTransactionId.newBuilder();
        builder.setAgentId(traceId.getAgentId());
        builder.setAgentStartTime(traceId.getAgentStartTime());
        builder.setSequence(traceId.getTransactionSequence());
        return builder.build();
    }

    private boolean isCompressedType(TraceId traceId) {
        return this.agentId.equals(traceId.getAgentId());
    }

    private PAcceptEvent newAcceptEvent(Span span) {
        PAcceptEvent.Builder builder = PAcceptEvent.newBuilder();
        builder.setRemoteAddr(span.getRemoteAddr());
        Shared shared = span.getTraceRoot().getShared();
        builder.setRpc(shared.getRpcName());
        builder.setEndPoint(shared.getEndPoint());
        PParentInfo pParentInfo = this.newParentInfo(span);
        if (pParentInfo != null) {
            builder.setParentInfo(pParentInfo);
        }
        return builder.build();
    }

    private PParentInfo newParentInfo(Span span) {
        String acceptorHost;
        short parentApplicationType;
        PParentInfo.Builder builder = PParentInfo.newBuilder();
        boolean isChanged = false;
        String parentApplicationName = span.getParentApplicationName();
        if (parentApplicationName != null) {
            builder.setParentApplicationName(parentApplicationName);
            isChanged = true;
        }
        if ((parentApplicationType = span.getParentApplicationType()) != 0) {
            builder.setParentApplicationType((int)parentApplicationType);
            isChanged = true;
        }
        if ((acceptorHost = span.getAcceptorHost()) != null) {
            builder.setAcceptorHost(acceptorHost);
            isChanged = true;
        }
        if (isChanged) {
            return builder.build();
        }
        return null;
    }

    private List<PSpanEvent> buildPSpanEventList(List<SpanEvent> spanEventList) {
        int eventSize = spanEventList.size();
        ArrayList<PSpanEvent> pSpanEventList = new ArrayList<PSpanEvent>(eventSize);
        for (SpanEvent spanEvent : spanEventList) {
            PSpanEvent.Builder pSpanEvent = this.buildPSpanEvent(spanEvent);
            pSpanEventList.add(pSpanEvent.build());
        }
        return pSpanEventList;
    }

    @VisibleForTesting
    PSpanChunk buildPSpanChunk(SpanChunk spanChunk) {
        PSpanChunk.Builder pSpanChunk = PSpanChunk.newBuilder();
        pSpanChunk.setVersion(1);
        pSpanChunk.setApplicationServiceType((int)this.applicationServiceType);
        TraceRoot traceRoot = spanChunk.getTraceRoot();
        TraceId traceId = traceRoot.getTraceId();
        PTransactionId transactionId = this.newTransactionId(traceId);
        pSpanChunk.setTransactionId(transactionId);
        pSpanChunk.setSpanId(traceId.getSpanId());
        Shared shared = traceRoot.getShared();
        String endPoint = shared.getEndPoint();
        if (endPoint != null) {
            pSpanChunk.setEndPoint(endPoint);
        }
        if (spanChunk instanceof AsyncSpanChunk) {
            AsyncSpanChunk asyncSpanChunk = (AsyncSpanChunk)spanChunk;
            LocalAsyncId localAsyncId = asyncSpanChunk.getLocalAsyncId();
            PLocalAsyncId.Builder pAsyncIdBuilder = PLocalAsyncId.newBuilder();
            pAsyncIdBuilder.setAsyncId(localAsyncId.getAsyncId());
            pAsyncIdBuilder.setSequence(localAsyncId.getSequence());
            PLocalAsyncId pLocalAsyncId = pAsyncIdBuilder.build();
            pSpanChunk.setLocalAsyncId(pLocalAsyncId);
        }
        this.spanProcessor.preProcess(spanChunk, pSpanChunk);
        List<SpanEvent> spanEventList = spanChunk.getSpanEventList();
        if (CollectionUtils.hasLength(spanEventList)) {
            List<PSpanEvent> pSpanEvents = this.buildPSpanEventList(spanEventList);
            pSpanChunk.addAllSpanEvent(pSpanEvents);
        }
        this.spanProcessor.postProcess(spanChunk, pSpanChunk);
        return pSpanChunk.build();
    }

    @VisibleForTesting
    public PSpanEvent.Builder buildPSpanEvent(SpanEvent spanEvent) {
        List<Annotation<?>> annotations;
        AsyncId asyncIdObject;
        PNextEvent nextEvent;
        PSpanEvent.Builder pSpanEvent = this.getSpanEventBuilder();
        if (spanEvent.getElapsedTime() != 0) {
            pSpanEvent.setEndElapsed(spanEvent.getElapsedTime());
        }
        pSpanEvent.setSequence(spanEvent.getSequence());
        pSpanEvent.setServiceType((int)spanEvent.getServiceType());
        if (spanEvent.getDepth() != -1) {
            pSpanEvent.setDepth(spanEvent.getDepth());
        }
        pSpanEvent.setApiId(spanEvent.getApiId());
        IntStringValue exceptionInfo = spanEvent.getExceptionInfo();
        if (exceptionInfo != null) {
            PIntStringValue pIntStringValue = this.buildPIntStringValue(exceptionInfo);
            pSpanEvent.setExceptionInfo(pIntStringValue);
        }
        if ((nextEvent = this.buildNextEvent(spanEvent)) != null) {
            pSpanEvent.setNextEvent(nextEvent);
        }
        if ((asyncIdObject = spanEvent.getAsyncIdObject()) != null) {
            pSpanEvent.setAsyncEvent(asyncIdObject.getAsyncId());
        }
        if (CollectionUtils.hasLength(annotations = spanEvent.getAnnotations())) {
            List<PAnnotation> pAnnotations = this.buildPAnnotation(annotations);
            pSpanEvent.addAllAnnotation(pAnnotations);
        }
        return pSpanEvent;
    }

    private PNextEvent buildNextEvent(SpanEvent spanEvent) {
        String destinationId;
        PMessageEvent.Builder messageEventBuilder = null;
        String endPoint = spanEvent.getEndPoint();
        if (endPoint != null) {
            messageEventBuilder = this.newPMessageEvent(messageEventBuilder);
            messageEventBuilder.setEndPoint(endPoint);
        }
        if (spanEvent.getNextSpanId() != -1L) {
            messageEventBuilder = this.newPMessageEvent(messageEventBuilder);
            messageEventBuilder.setNextSpanId(spanEvent.getNextSpanId());
        }
        if ((destinationId = spanEvent.getDestinationId()) != null) {
            messageEventBuilder = this.newPMessageEvent(messageEventBuilder);
            messageEventBuilder.setDestinationId(destinationId);
        }
        if (messageEventBuilder != null) {
            PNextEvent.Builder nextEvent = PNextEvent.newBuilder();
            nextEvent.setMessageEvent(messageEventBuilder.build());
            return nextEvent.build();
        }
        return null;
    }

    private PMessageEvent.Builder newPMessageEvent(PMessageEvent.Builder builder) {
        if (builder == null) {
            return PMessageEvent.newBuilder();
        }
        return builder;
    }

    private PIntStringValue buildPIntStringValue(IntStringValue exceptionInfo) {
        PIntStringValue.Builder builder = PIntStringValue.newBuilder();
        builder.setIntValue(exceptionInfo.getIntValue());
        if (exceptionInfo.getStringValue() != null) {
            StringValue stringValue = StringValue.of((String)exceptionInfo.getStringValue());
            builder.setStringValue(stringValue);
        }
        return builder.build();
    }

    @VisibleForTesting
    List<PAnnotation> buildPAnnotation(List<Annotation<?>> annotations) {
        ArrayList<PAnnotation> tAnnotationList = new ArrayList<PAnnotation>(annotations.size());
        for (Annotation<?> annotation : annotations) {
            PAnnotation.Builder builder = this.getAnnotationBuilder();
            builder.setKey(annotation.getKey());
            PAnnotationValue pAnnotationValue = this.grpcAnnotationValueMapper.buildPAnnotationValue(annotation);
            if (pAnnotationValue != null) {
                builder.setValue(pAnnotationValue);
            }
            PAnnotation pAnnotation = builder.build();
            tAnnotationList.add(pAnnotation);
        }
        return tAnnotationList;
    }

    private PAnnotation.Builder getAnnotationBuilder() {
        this.pAnnotationBuilder.clear();
        return this.pAnnotationBuilder;
    }

    private PSpanEvent.Builder getSpanEventBuilder() {
        this.pSpanEventBuilder.clear();
        return this.pSpanEventBuilder;
    }

    public String toString() {
        return "GrpcSpanMessageConverter{agentId='" + this.agentId + '\'' + ", applicationServiceType=" + this.applicationServiceType + ", spanProcessor=" + this.spanProcessor + '}';
    }
}

