/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.javamodule;

import com.navercorp.pinpoint.bootstrap.module.ClassFileTransformModuleAdaptor;
import com.navercorp.pinpoint.bootstrap.module.JavaModule;
import com.navercorp.pinpoint.bootstrap.module.JavaModuleFactory;
import com.navercorp.pinpoint.common.util.ClassUtils;
import com.navercorp.pinpoint.profiler.context.javamodule.PackageUtils;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassFileTransformerModuleHandler
implements ClassFileTransformModuleAdaptor {
    private final ClassFileTransformer delegate;
    private final JavaModuleFactory javaModuleFactory;
    private final JavaModule bootstrapModule;
    private final Logger logger = LogManager.getLogger(this.getClass());

    public ClassFileTransformerModuleHandler(Instrumentation instrumentation, ClassFileTransformer delegate, JavaModuleFactory javaModuleFactory) {
        Objects.requireNonNull(instrumentation, "instrumentation");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.javaModuleFactory = Objects.requireNonNull(javaModuleFactory, "javaModuleFactory");
        this.bootstrapModule = javaModuleFactory.wrapFromClass(JavaModuleFactory.class);
    }

    public byte[] transform(Object transformedModuleObject, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        byte[] transform = this.delegate.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        if (transformedModuleObject == null) {
            return transform;
        }
        if (transform != null && transform != classfileBuffer) {
            if (!this.javaModuleFactory.isNamedModule(transformedModuleObject)) {
                return transform;
            }
            JavaModule transformedModule = this.javaModuleFactory.wrapFromModule(transformedModuleObject);
            this.addModulePermission(transformedModule, className, this.bootstrapModule);
            if (loader != Object.class.getClassLoader()) {
                Object pluginModuleObject = this.getPluginModule(loader);
                JavaModule pluginModule = this.javaModuleFactory.wrapFromModule(pluginModuleObject);
                this.addModulePermission(transformedModule, className, pluginModule);
            }
        }
        return transform;
    }

    private Object getPluginModule(ClassLoader loader) {
        return this.javaModuleFactory.getUnnamedModule(loader);
    }

    private void addModulePermission(JavaModule transformedModule, String className, JavaModule targetModule) {
        String packageName;
        if (!transformedModule.canRead(targetModule)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("addReads module:{} target:{}", (Object)transformedModule, (Object)targetModule);
            }
            transformedModule.addReads(targetModule);
        }
        if ((packageName = this.getPackageName(className)) != null && !transformedModule.isExported(packageName, targetModule)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("addExports module:{} pkg:{} target:{}", (Object)transformedModule, (Object)packageName, (Object)targetModule);
            }
            transformedModule.addExports(packageName, targetModule);
        }
    }

    private String getPackageName(String className) {
        String packageName = ClassUtils.getPackageName((String)className, (char)'/', null);
        if (packageName == null) {
            return null;
        }
        return PackageUtils.getPackageNameFromInternalName(className);
    }
}

