/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindVariableService;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.bindvalue.BindValueConverter;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.bindvalue.BindValueUtils;
import com.navercorp.pinpoint.profiler.jdbc.DefaultBindVariableService;
import com.navercorp.pinpoint.profiler.jdbc.JdbcContextConfig;
import java.util.Objects;

public class BindVariableServiceProvider
implements Provider<BindVariableService> {
    private final JdbcContextConfig jdbcContextConfig;

    @Inject
    public BindVariableServiceProvider(ProfilerConfig profilerConfig) {
        Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.jdbcContextConfig = new JdbcContextConfig(profilerConfig);
    }

    public BindVariableService get() {
        int maxWidth = this.jdbcContextConfig.getMaxWidth();
        com.navercorp.pinpoint.profiler.jdbc.BindValueConverter bindVariable = com.navercorp.pinpoint.profiler.jdbc.BindValueConverter.defaultBindValueConverter(maxWidth);
        if (this.jdbcContextConfig.getByteFormat() == JdbcContextConfig.ByteFormat.raw) {
            bindVariable.setRawBytesConverter();
        }
        DefaultBindVariableService bindVariableService = new DefaultBindVariableService(bindVariable);
        this.oldVersionCompatibility(bindVariableService);
        return bindVariableService;
    }

    private void oldVersionCompatibility(BindVariableService bindVariableService) {
        BindValueConverter.setBindVariableService((BindVariableService)bindVariableService);
        BindValueUtils.setBindVariableService((BindVariableService)bindVariableService);
    }
}

