/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.TransportModule;
import com.navercorp.pinpoint.profiler.context.TraceDataFormatVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceDataFormatVersionProvider
implements Provider<TraceDataFormatVersion> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final TraceDataFormatVersion version;

    @Inject
    public TraceDataFormatVersionProvider(ProfilerConfig profilerConfig) {
        this.version = this.getVersion(profilerConfig);
        this.logger.info("TraceDataFormatVersion:{}", (Object)this.version);
    }

    private TraceDataFormatVersion getVersion(ProfilerConfig profilerConfig) {
        TransportModule transportModule = profilerConfig.getTransportModule();
        this.logger.info("TransportModule:{}", (Object)transportModule);
        if (TransportModule.THRIFT == transportModule) {
            String version = profilerConfig.readString("profiler.transport.thrift.trace.dataformat.version", "v1");
            if ("v1".equalsIgnoreCase(version)) {
                return TraceDataFormatVersion.V1;
            }
            throw new UnsupportedOperationException("unknown profiler.transport.thrift.trace.dataformat.version:" + version);
        }
        if (TransportModule.GRPC == transportModule) {
            String version = profilerConfig.readString("profiler.transport.grpc.trace.dataformat.version", "v2");
            if ("v2".equalsIgnoreCase(version)) {
                return TraceDataFormatVersion.V2;
            }
            throw new UnsupportedOperationException("unknown profiler.transport.grpc.trace.dataformat.version:" + version);
        }
        throw new UnsupportedOperationException("unknown transportModule:" + transportModule);
    }

    public TraceDataFormatVersion get() {
        return this.version;
    }
}

