/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.profiler.context.AsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.errorhandler.IgnoreErrorHandler;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.recorder.DefaultSpanRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.RecorderFactory;
import com.navercorp.pinpoint.profiler.context.recorder.TraceRootSpanRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedAsyncSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedSpanEventRecorder;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import java.util.Objects;

public class DefaultRecorderFactory
implements RecorderFactory {
    private final StringMetaDataService stringMetaDataService;
    private final SqlMetaDataService sqlMetaDataService;
    private final Provider<AsyncContextFactory> asyncContextFactoryProvider;
    private final IgnoreErrorHandler errorHandler;

    @Inject
    public DefaultRecorderFactory(Provider<AsyncContextFactory> asyncContextFactoryProvider, StringMetaDataService stringMetaDataService, SqlMetaDataService sqlMetaDataService, IgnoreErrorHandler errorHandler) {
        this.asyncContextFactoryProvider = Objects.requireNonNull(asyncContextFactoryProvider, "asyncContextFactoryProvider");
        this.stringMetaDataService = Objects.requireNonNull(stringMetaDataService, "stringMetaDataService");
        this.sqlMetaDataService = Objects.requireNonNull(sqlMetaDataService, "sqlMetaDataService");
        this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler");
    }

    @Override
    public SpanRecorder newSpanRecorder(Span span, boolean isRoot, boolean sampling) {
        return new DefaultSpanRecorder(span, isRoot, sampling, this.stringMetaDataService, this.sqlMetaDataService, this.errorHandler);
    }

    @Override
    public SpanRecorder newTraceRootSpanRecorder(TraceRoot traceRoot, boolean sampling) {
        return new TraceRootSpanRecorder(traceRoot, sampling);
    }

    @Override
    public WrappedSpanEventRecorder newWrappedSpanEventRecorder(TraceRoot traceRoot) {
        AsyncContextFactory asyncContextFactory = (AsyncContextFactory)this.asyncContextFactoryProvider.get();
        return new WrappedSpanEventRecorder(traceRoot, asyncContextFactory, this.stringMetaDataService, this.sqlMetaDataService, this.errorHandler);
    }

    @Override
    public WrappedSpanEventRecorder newWrappedSpanEventRecorder(TraceRoot traceRoot, AsyncState asyncState) {
        Objects.requireNonNull(asyncState, "asyncState");
        AsyncContextFactory asyncContextFactory = (AsyncContextFactory)this.asyncContextFactoryProvider.get();
        return new WrappedAsyncSpanEventRecorder(traceRoot, asyncContextFactory, this.stringMetaDataService, this.sqlMetaDataService, this.errorHandler, asyncState);
    }
}

