/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.channelz;

import com.navercorp.pinpoint.grpc.channelz.ChannelzRegistry;
import com.navercorp.pinpoint.grpc.server.MetadataServerTransportFilter;
import com.navercorp.pinpoint.grpc.server.SocketAddressUtils;
import com.navercorp.pinpoint.grpc.server.TransportMetadata;
import io.grpc.Attributes;
import io.grpc.ServerTransportFilter;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChannelzServerTransportFilter
extends ServerTransportFilter {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ChannelzRegistry registry;

    public ChannelzServerTransportFilter(ChannelzRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry");
    }

    public Attributes transportReady(Attributes transportAttrs) {
        TransportMetadata transportMetadata = this.getTransportMetadata(transportAttrs);
        long logId = transportMetadata.getLogId();
        InetSocketAddress remoteAddress = transportMetadata.getRemoteAddress();
        InetSocketAddress localAddress = transportMetadata.getLocalAddress();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Add logId:{} remoteAddress:{} localAddress:{}", (Object)logId, (Object)SocketAddressUtils.toString(remoteAddress), (Object)SocketAddressUtils.toString(localAddress));
        }
        this.registry.addSocket(logId, remoteAddress, localAddress);
        return transportAttrs;
    }

    private TransportMetadata getTransportMetadata(Attributes transportAttrs) {
        return (TransportMetadata)transportAttrs.get(MetadataServerTransportFilter.TRANSPORT_METADATA_KEY);
    }

    public void transportTerminated(Attributes transportAttrs) {
        if (transportAttrs == null) {
            return;
        }
        TransportMetadata transportMetadata = this.getTransportMetadata(transportAttrs);
        InetSocketAddress remoteAddress = transportMetadata.getRemoteAddress();
        Long logId = this.registry.removeSocket(remoteAddress);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Remove logId:{} remoteAddress:{}", (Object)logId, (Object)remoteAddress);
        }
    }
}

