/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.stream.compact.CompactContext;
import org.apache.flink.connector.file.table.stream.compact.CompactReader;
import org.apache.flink.connector.file.table.stream.compact.CompactWriter;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactFileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CompactFileUtils.class);

    @Nullable
    public static <T> Path doCompact(FileSystem fileSystem, String partition, List<Path> paths, Path target, Configuration config, CompactReader.Factory<T> readerFactory, CompactWriter.Factory<T> writerFactory) throws IOException {
        if (paths.size() == 0) {
            return null;
        }
        HashMap<Path, Long> inputMap = new HashMap<Path, Long>();
        for (Path path : paths) {
            inputMap.put(path, fileSystem.getFileStatus(path).getLen());
        }
        if (fileSystem.exists(target)) {
            return target;
        }
        CompactFileUtils.checkExist(fileSystem, paths);
        long startMillis = System.currentTimeMillis();
        boolean success = false;
        if (paths.size() == 1) {
            success = CompactFileUtils.doSingleFileMove(fileSystem, paths.get(0), target);
        }
        if (!success) {
            CompactFileUtils.doMultiFilesCompact(partition, paths, target, config, fileSystem, readerFactory, writerFactory);
        }
        HashMap<Path, Long> targetMap = new HashMap<Path, Long>();
        targetMap.put(target, fileSystem.getFileStatus(target).getLen());
        double costSeconds = (double)(System.currentTimeMillis() - startMillis) / 1000.0;
        LOG.info("Compaction time cost is '{}S', output per file as following format: name=size(byte), target file is '{}', input files are '{}'", new Object[]{costSeconds, targetMap, inputMap});
        return target;
    }

    private static boolean doSingleFileMove(FileSystem fileSystem, Path src, Path dst) throws IOException {
        RecoverableWriter writer;
        try {
            writer = fileSystem.createRecoverableWriter();
        }
        catch (UnsupportedOperationException ignore) {
            return false;
        }
        RecoverableFsDataOutputStream out = writer.open(dst);
        try (FSDataInputStream in = fileSystem.open(src);){
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (boolean)false);
        }
        catch (Throwable t) {
            out.close();
            throw t;
        }
        out.closeForCommit().commit();
        return true;
    }

    private static <T> void doMultiFilesCompact(String partition, List<Path> files, Path dst, Configuration config, FileSystem fileSystem, CompactReader.Factory<T> readerFactory, CompactWriter.Factory<T> writerFactory) throws IOException {
        CompactWriter<T> writer = writerFactory.create(CompactContext.create(config, fileSystem, partition, dst));
        for (Path path : files) {
            CompactReader<T> reader = readerFactory.create(CompactContext.create(config, fileSystem, partition, path));
            Throwable throwable = null;
            try {
                T record;
                while ((record = reader.read()) != null) {
                    writer.write(record);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        writer.commit();
    }

    private static void checkExist(FileSystem fileSystem, List<Path> candidates) throws IOException {
        for (Path path : candidates) {
            if (fileSystem.exists(path)) continue;
            throw new IOException("Compaction file not exist: " + path);
        }
    }
}

