/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.bridging;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlTableFunction;
import org.apache.calcite.sql.TableCharacteristic;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.flink.annotation.Internal;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.RexFactory;
import org.apache.flink.table.planner.functions.bridging.BridgingUtils;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.inference.StaticArgument;
import org.apache.flink.table.types.inference.StaticArgumentTrait;
import org.apache.flink.table.types.inference.SystemTypeInference;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.util.Preconditions;

@Internal
public class BridgingSqlFunction
extends SqlFunction {
    private final DataTypeFactory dataTypeFactory;
    private final FlinkTypeFactory typeFactory;
    private final RexFactory rexFactory;
    private final ContextResolvedFunction resolvedFunction;
    protected final TypeInference typeInference;

    private BridgingSqlFunction(DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, RexFactory rexFactory, SqlKind kind, ContextResolvedFunction resolvedFunction, TypeInference typeInference) {
        super(BridgingUtils.createName(resolvedFunction), BridgingUtils.createSqlIdentifier(resolvedFunction), kind, BridgingUtils.createSqlReturnTypeInference(dataTypeFactory, resolvedFunction.getDefinition(), typeInference), BridgingUtils.createSqlOperandTypeInference(dataTypeFactory, resolvedFunction.getDefinition(), typeInference), BridgingUtils.createSqlOperandTypeChecker(dataTypeFactory, resolvedFunction.getDefinition(), typeInference), BridgingUtils.createSqlFunctionCategory(resolvedFunction));
        this.dataTypeFactory = dataTypeFactory;
        this.typeFactory = typeFactory;
        this.rexFactory = rexFactory;
        this.resolvedFunction = resolvedFunction;
        this.typeInference = typeInference;
    }

    public static BridgingSqlFunction of(DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, RexFactory rexFactory, SqlKind kind, ContextResolvedFunction resolvedFunction, TypeInference typeInference) {
        FunctionKind functionKind = resolvedFunction.getDefinition().getKind();
        Preconditions.checkState((functionKind == FunctionKind.SCALAR || functionKind == FunctionKind.ASYNC_SCALAR || functionKind == FunctionKind.TABLE || functionKind == FunctionKind.PROCESS_TABLE ? 1 : 0) != 0, (Object)"Scalar or table function kind expected.");
        TypeInference systemTypeInference = SystemTypeInference.of((FunctionKind)functionKind, (TypeInference)typeInference);
        if (functionKind == FunctionKind.TABLE || functionKind == FunctionKind.PROCESS_TABLE) {
            return new WithTableFunction(dataTypeFactory, typeFactory, rexFactory, kind, resolvedFunction, systemTypeInference);
        }
        return new BridgingSqlFunction(dataTypeFactory, typeFactory, rexFactory, kind, resolvedFunction, systemTypeInference);
    }

    public static BridgingSqlFunction of(FlinkContext context, FlinkTypeFactory typeFactory, ContextResolvedFunction resolvedFunction) {
        DataTypeFactory dataTypeFactory = context.getCatalogManager().getDataTypeFactory();
        TypeInference typeInference = resolvedFunction.getDefinition().getTypeInference(dataTypeFactory);
        return BridgingSqlFunction.of(dataTypeFactory, typeFactory, context.getRexFactory(), SqlKind.OTHER_FUNCTION, resolvedFunction, typeInference);
    }

    public static BridgingSqlFunction of(RelOptCluster cluster, ContextResolvedFunction resolvedFunction) {
        FlinkContext context = ShortcutUtils.unwrapContext(cluster);
        FlinkTypeFactory typeFactory = ShortcutUtils.unwrapTypeFactory(cluster);
        return BridgingSqlFunction.of(context, typeFactory, resolvedFunction);
    }

    public static BridgingSqlFunction of(RelOptCluster cluster, BuiltInFunctionDefinition functionDefinition) {
        return BridgingSqlFunction.of(cluster, ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((String)functionDefinition.getName()), (FunctionDefinition)functionDefinition));
    }

    public DataTypeFactory getDataTypeFactory() {
        return this.dataTypeFactory;
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public RexFactory getRexFactory() {
        return this.rexFactory;
    }

    public ContextResolvedFunction getResolvedFunction() {
        return this.resolvedFunction;
    }

    public FunctionDefinition getDefinition() {
        return this.resolvedFunction.getDefinition();
    }

    public TypeInference getTypeInference() {
        return this.typeInference;
    }

    @Override
    public boolean isDeterministic() {
        return this.resolvedFunction.getDefinition().isDeterministic();
    }

    public static class WithTableFunction
    extends BridgingSqlFunction
    implements SqlTableFunction {
        private WithTableFunction(DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, RexFactory rexFactory, SqlKind kind, ContextResolvedFunction resolvedFunction, TypeInference systemTypeInference) {
            super(dataTypeFactory, typeFactory, rexFactory, kind, resolvedFunction, systemTypeInference);
        }

        @Override
        public SqlReturnTypeInference getRowTypeInference() {
            SqlReturnTypeInference inference = this.getReturnTypeInference();
            assert (inference != null);
            return opBinding -> {
                RelDataType relDataType = inference.inferReturnType(opBinding);
                assert (relDataType != null);
                List<RelDataTypeField> fields = relDataType.getFieldList();
                return opBinding.getTypeFactory().createStructType(StructKind.FULLY_QUALIFIED, fields.stream().map(RelDataTypeField::getType).collect(Collectors.toList()), fields.stream().map(RelDataTypeField::getName).collect(Collectors.toList()));
            };
        }

        @Override
        public @Nullable TableCharacteristic tableCharacteristic(int ordinal) {
            TableCharacteristic.Semantics semantics;
            List args = this.typeInference.getStaticArguments().orElse(null);
            if (args == null || ordinal >= args.size()) {
                return null;
            }
            StaticArgument arg = (StaticArgument)args.get(ordinal);
            if (arg.is(StaticArgumentTrait.TABLE_AS_ROW)) {
                semantics = TableCharacteristic.Semantics.ROW;
            } else if (arg.is(StaticArgumentTrait.TABLE_AS_SET)) {
                semantics = TableCharacteristic.Semantics.SET;
            } else {
                return null;
            }
            return TableCharacteristic.builder(semantics).build();
        }

        @Override
        public boolean argumentMustBeScalar(int ordinal) {
            List args = this.typeInference.getStaticArguments().orElse(null);
            if (args == null || ordinal >= args.size()) {
                return true;
            }
            StaticArgument arg = (StaticArgument)args.get(ordinal);
            return !arg.is(StaticArgumentTrait.TABLE);
        }
    }
}

