/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.Set;
import org.apache.flink.sql.parser.ddl.SqlAlterCatalogReset;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CommonCatalogOptions;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AlterCatalogResetOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlAlterCatalogResetConverter
implements SqlNodeConverter<SqlAlterCatalogReset> {
    @Override
    public Operation convertSqlNode(SqlAlterCatalogReset sqlAlterCatalogReset, SqlNodeConverter.ConvertContext context) {
        String type = CommonCatalogOptions.CATALOG_TYPE.key();
        Set<String> resetKeys = sqlAlterCatalogReset.getResetKeys();
        if (resetKeys.isEmpty() || resetKeys.contains(type)) {
            String exMsg = resetKeys.isEmpty() ? "ALTER CATALOG RESET does not support empty key" : String.format("ALTER CATALOG RESET does not support changing '%s'", type);
            throw new ValidationException(exMsg);
        }
        return new AlterCatalogResetOperation(sqlAlterCatalogReset.catalogName(), sqlAlterCatalogReset.getResetKeys());
    }
}

