/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Util;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecHashJoin;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalJoinBase;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import org.apache.flink.table.planner.plan.utils.JoinUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\u000e\u001c\u00019B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003A\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011U\u0003!Q1A\u0005\u0002YC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\t=\u0002\u0011)\u0019!C\u0001-\"Aq\f\u0001B\u0001B\u0003%q\u000b\u0003\u0005a\u0001\t\u0015\r\u0011\"\u0001W\u0011!\t\u0007A!A!\u0002\u00139\u0006\u0002\u00032\u0001\u0005\u000b\u0007I\u0011\u0001,\t\u0011\r\u0004!\u0011!Q\u0001\n]CQ\u0001\u001a\u0001\u0005\u0002\u0015Dq!\u001d\u0001C\u0002\u0013\u0005!\u000f\u0003\u0004~\u0001\u0001\u0006Ia\u001d\u0005\u0006}\u0002!\te \u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\tI\u0003\u0001C!\u0003WA\u0001\"a\u0013\u0001\t\u00039\u0013Q\n\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\t)\u0007\u0001C\u0005\u0003OBq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002\u0014\u0002!I!!&\u0003+\t\u000bGo\u00195QQf\u001c\u0018nY1m\u0011\u0006\u001c\bNS8j]*\u0011A$H\u0001\u0006E\u0006$8\r\u001b\u0006\u0003=}\t\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u0006\u0003A\u0005\nQA\\8eKNT!AI\u0012\u0002\tAd\u0017M\u001c\u0006\u0003I\u0015\nq\u0001\u001d7b]:,'O\u0003\u0002'O\u0005)A/\u00192mK*\u0011\u0001&K\u0001\u0006M2Lgn\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0003C\u0001\u00192\u001b\u0005Y\u0012B\u0001\u001a\u001c\u0005U\u0011\u0015\r^2i!\"L8/[2bY*{\u0017N\u001c\"bg\u0016\fqa\u00197vgR,'\u000f\u0005\u00026s5\taG\u0003\u0002#o)\u0011\u0001(K\u0001\bG\u0006d7-\u001b;f\u0013\tQdGA\u0007SK2|\u0005\u000f^\"mkN$XM]\u0001\tiJ\f\u0017\u000e^*fiB\u0011Q'P\u0005\u0003}Y\u00121BU3m)J\f\u0017\u000e^*fi\u00069A.\u001a4u%\u0016d\u0007CA!E\u001b\u0005\u0011%BA\"8\u0003\r\u0011X\r\\\u0005\u0003\u000b\n\u0013qAU3m\u001d>$W-\u0001\u0005sS\u001eDGOU3m\u0003%\u0019wN\u001c3ji&|g\u000e\u0005\u0002J\u00196\t!J\u0003\u0002Lo\u0005\u0019!/\u001a=\n\u00055S%a\u0002*fq:{G-Z\u0001\tU>Lg\u000eV=qKB\u0011\u0001kU\u0007\u0002#*\u0011!KQ\u0001\u0005G>\u0014X-\u0003\u0002U#\nY!j\\5o%\u0016dG+\u001f9f\u0003-aWM\u001a;Jg\n+\u0018\u000e\u001c3\u0016\u0003]\u0003\"\u0001W.\u000e\u0003eS\u0011AW\u0001\u0006g\u000e\fG.Y\u0005\u00039f\u0013qAQ8pY\u0016\fg.\u0001\u0007mK\u001a$\u0018j\u001d\"vS2$\u0007%A\u0006jg\n\u0013x.\u00193dCN$\u0018\u0001D5t\u0005J|\u0017\rZ2bgR\u0004\u0013a\u0005;ss\u0012K7\u000f^5oGR\u0014U/\u001b7e%><\u0018\u0001\u0006;ss\u0012K7\u000f^5oGR\u0014U/\u001b7e%><\b%A\nxSRD'j\u001c2TiJ\fG/Z4z\u0011&tG/\u0001\u000bxSRD'j\u001c2TiJ\fG/Z4z\u0011&tG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0017\u0019<\u0007.\u001b6lY6tw\u000e\u001d\t\u0003a\u0001AQaM\bA\u0002QBQaO\bA\u0002qBQaP\bA\u0002\u0001CQAR\bA\u0002\u0001CQaR\bA\u0002!CQAT\bA\u0002=CQ!V\bA\u0002]CQAX\bA\u0002]CQ\u0001Y\bA\u0002]CQAY\bA\u0002]\u000bA\u0002[1tQ*{\u0017N\u001c+za\u0016,\u0012a\u001d\t\u0003inl\u0011!\u001e\u0006\u0003m^\fAA[8j]*\u0011\u00010_\u0001\n_B,'/\u0019;peNT!A_\u0013\u0002\u000fI,h\u000e^5nK&\u0011A0\u001e\u0002\r\u0011\u0006\u001c\bNS8j]RK\b/Z\u0001\u000eQ\u0006\u001c\bNS8j]RK\b/\u001a\u0011\u0002\t\r|\u0007/\u001f\u000b\u000f\u0003\u0003\t9!!\u0003\u0002\u000e\u0005E\u0011QCA\f!\r\u0001\u00161A\u0005\u0004\u0003\u000b\t&\u0001\u0002&pS:DQa\u000f\nA\u0002qBa!a\u0003\u0013\u0001\u0004A\u0015!D2p]\u0012LG/[8o\u000bb\u0004(\u000f\u0003\u0004\u0002\u0010I\u0001\r\u0001Q\u0001\u0005Y\u00164G\u000f\u0003\u0004\u0002\u0014I\u0001\r\u0001Q\u0001\u0006e&<\u0007\u000e\u001e\u0005\u0006\u001dJ\u0001\ra\u0014\u0005\u0007\u00033\u0011\u0002\u0019A,\u0002\u0019M,W.\u001b&pS:$uN\\3\u0002\u0019\u0015D\b\u000f\\1j]R+'/\\:\u0015\t\u0005}\u0011Q\u0005\t\u0004\u0003\u0006\u0005\u0012bAA\u0012\u0005\nI!+\u001a7Xe&$XM\u001d\u0005\b\u0003O\u0019\u0002\u0019AA\u0010\u0003\t\u0001x/A\bd_6\u0004X\u000f^3TK247i\\:u)\u0019\ti#a\r\u0002<A\u0019Q'a\f\n\u0007\u0005EbG\u0001\u0006SK2|\u0005\u000f^\"pgRDa\u0001\n\u000bA\u0002\u0005U\u0002cA\u001b\u00028%\u0019\u0011\u0011\b\u001c\u0003\u001bI+Gn\u00149u!2\fgN\\3s\u0011\u001d\ti\u0004\u0006a\u0001\u0003\u007f\t!!\\9\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007R1!!\u0012C\u0003!iW\r^1eCR\f\u0017\u0002BA%\u0003\u0007\u0012\u0001CU3m\u001b\u0016$\u0018\rZ1uCF+XM]=\u0002#MDWO\u001a4mK\n+\u0018\u000e\u001c3D_VtG\u000f\u0006\u0003\u0002P\u0005U\u0003c\u0001-\u0002R%\u0019\u00111K-\u0003\u0007%sG\u000fC\u0004\u0002>U\u0001\r!a\u0010\u0002\u001bM\fG/[:gsR\u0013\u0018-\u001b;t)\u0011\tY&!\u0019\u0011\ta\u000bi\u0006Q\u0005\u0004\u0003?J&AB(qi&|g\u000e\u0003\u0004\u0002dY\u0001\r\u0001P\u0001\u0011e\u0016\fX/\u001b:fIR\u0013\u0018-\u001b;TKR\f1e]1uSN4\u0017\u0010\u0016:bSR\u001cxJ\u001c(p]\n\u0013x.\u00193dCN$\b*Y:i\u0015>Lg\u000e\u0006\u0003\u0002\\\u0005%\u0004BBA2/\u0001\u0007A(A\nue\u0006t7\u000f\\1uKR{W\t_3d\u001d>$W\r\u0006\u0002\u0002pA\"\u0011\u0011OAA!\u0019\t\u0019(!\u001f\u0002~5\u0011\u0011Q\u000f\u0006\u0004\u0003oz\u0012\u0001B3yK\u000eLA!a\u001f\u0002v\tAQ\t_3d\u001d>$W\r\u0005\u0003\u0002\u0000\u0005\u0005E\u0002\u0001\u0003\f\u0003\u0007C\u0012\u0011!A\u0001\u0006\u0003\t)IA\u0002`IE\nB!a\"\u0002\u000eB\u0019\u0001,!#\n\u0007\u0005-\u0015LA\u0004O_RD\u0017N\\4\u0011\u0007a\u000by)C\u0002\u0002\u0012f\u00131!\u00118z\u0003I9W\r^%oaV$\bK]8qKJ$\u0018.Z:\u0016\u0005\u0005]\u0005c\u0002-\u0002\u001a\u0006u\u0015QT\u0005\u0004\u00037K&A\u0002+va2,'\u0007\u0005\u0003\u0002t\u0005}\u0015\u0002BAQ\u0003k\u0012Q\"\u00138qkR\u0004&o\u001c9feRL\b")
public class BatchPhysicalHashJoin
extends BatchPhysicalJoinBase {
    private final RelOptCluster cluster;
    private final boolean leftIsBuild;
    private final boolean isBroadcast;
    private final boolean tryDistinctBuildRow;
    private final boolean withJobStrategyHint;
    private final HashJoinType hashJoinType;

    public boolean leftIsBuild() {
        return this.leftIsBuild;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public boolean tryDistinctBuildRow() {
        return this.tryDistinctBuildRow;
    }

    public boolean withJobStrategyHint() {
        return this.withJobStrategyHint;
    }

    public HashJoinType hashJoinType() {
        return this.hashJoinType;
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new BatchPhysicalHashJoin(this.cluster, traitSet, left, right, conditionExpr, joinType, this.leftIsBuild(), this.isBroadcast(), this.tryDistinctBuildRow(), this.withJobStrategyHint());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("isBroadcast", "true", this.isBroadcast()).item("build", this.leftIsBuild() ? "left" : "right").itemIf("tryDistinctBuildRow", "true", this.tryDistinctBuildRow());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Tuple2 tuple2;
        Double leftRowCnt = mq.getRowCount(this.getLeft());
        Double rightRowCnt = mq.getRowCount(this.getRight());
        if (leftRowCnt == null || rightRowCnt == null) {
            return null;
        }
        double cpuCost = (double)FlinkCost$.MODULE$.HASH_CPU_COST() * (Predef$.MODULE$.Double2double(leftRowCnt) + Predef$.MODULE$.Double2double(rightRowCnt));
        Tuple2 tuple22 = tuple2 = this.leftIsBuild() ? new Tuple2((Object)leftRowCnt, (Object)FlinkRelMdUtil$.MODULE$.binaryRowAverageSize(this.getLeft())) : new Tuple2((Object)rightRowCnt, (Object)FlinkRelMdUtil$.MODULE$.binaryRowAverageSize(this.getRight()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Double buildRowCount = (Double)tuple2._1();
        Double buildRowSize = (Double)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)buildRowCount, (Object)buildRowSize);
        Double buildRowCount2 = (Double)tuple23._1();
        Double buildRowSize2 = (Double)tuple23._2();
        double bucketSize = Predef$.MODULE$.Double2double(buildRowCount2) * (double)8 / (double)FlinkCost$.MODULE$.HASH_COLLISION_WEIGHT();
        double recordSize = Predef$.MODULE$.Double2double(buildRowCount2) * (Predef$.MODULE$.Double2double(buildRowSize2) + (double)4);
        double memCost = (bucketSize + recordSize) * (double)this.shuffleBuildCount(mq);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        return costFactory.makeCost(Predef$.MODULE$.Double2double(mq.getRowCount(this)), cpuCost, 0.0, 0.0, memCost);
    }

    public int shuffleBuildCount(RelMetadataQuery mq) {
        RelNode probeRel;
        RelNode relNode = probeRel = this.leftIsBuild() ? this.getRight() : this.getLeft();
        if (this.isBroadcast()) {
            double rowCount = Util.first(mq.getRowCount(probeRel), 1.0);
            double shuffleCount = rowCount * Predef$.MODULE$.Double2double(mq.getAverageRowSize(probeRel)) / (double)FlinkCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE();
            return Math.max(1, (int)shuffleCount);
        }
        return 1;
    }

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        if (!this.isBroadcast()) {
            return this.satisfyTraitsOnNonBroadcastHashJoin(requiredTraitSet);
        }
        return this.satisfyTraitsOnBroadcastJoin(requiredTraitSet, this.leftIsBuild());
    }

    private Option<RelNode> satisfyTraitsOnNonBroadcastHashJoin(RelTraitSet requiredTraitSet) {
        FlinkRelDistribution requiredDistribution = requiredTraitSet.getTrait(FlinkRelDistributionTraitDef$.MODULE$.INSTANCE());
        Tuple3<Object, FlinkRelDistribution, FlinkRelDistribution> tuple3 = this.satisfyHashDistributionOnNonBroadcastJoin(requiredDistribution);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        boolean canSatisfyDistribution = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
        FlinkRelDistribution leftRequiredDistribution = (FlinkRelDistribution)tuple3._2();
        FlinkRelDistribution rightRequiredDistribution = (FlinkRelDistribution)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)canSatisfyDistribution), (Object)leftRequiredDistribution, (Object)rightRequiredDistribution);
        boolean canSatisfyDistribution2 = BoxesRunTime.unboxToBoolean((Object)tuple32._1());
        FlinkRelDistribution leftRequiredDistribution2 = (FlinkRelDistribution)tuple32._2();
        FlinkRelDistribution rightRequiredDistribution2 = (FlinkRelDistribution)tuple32._3();
        if (!canSatisfyDistribution2) {
            return None$.MODULE$;
        }
        Function1 & Serializable & scala.Serializable toRestrictHashDistributionByKeys = (Function1 & Serializable & scala.Serializable)distribution -> this.getCluster().getPlanner().emptyTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL()).replace((RelTrait)distribution);
        RelTraitSet leftRequiredTraits = (RelTraitSet)toRestrictHashDistributionByKeys.apply((Object)leftRequiredDistribution2);
        RelTraitSet rightRequiredTraits = (RelTraitSet)toRestrictHashDistributionByKeys.apply((Object)rightRequiredDistribution2);
        RelNode newLeft = RelOptRule.convert(this.getLeft(), leftRequiredTraits);
        RelNode newRight = RelOptRule.convert(this.getRight(), rightRequiredTraits);
        RelTraitSet providedTraits = this.getTraitSet().replace(requiredDistribution);
        return new Some((Object)this.copy(providedTraits, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)newLeft, (List)new .colon.colon((Object)newRight, (List)Nil$.MODULE$)))));
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        JoinUtil$.MODULE$.validateJoinSpec(this.joinSpec(), FlinkTypeFactory$.MODULE$.toLogicalRowType(this.left.getRowType()), FlinkTypeFactory$.MODULE$.toLogicalRowType(this.right.getRowType()), JoinUtil$.MODULE$.validateJoinSpec$default$4());
        Tuple4<Object, Object, Object, Object> tuple4 = JoinUtil$.MODULE$.getEstimatedRowStats(this);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int leftRowSize = BoxesRunTime.unboxToInt((Object)tuple4._1());
        long leftRowCount = BoxesRunTime.unboxToLong((Object)tuple4._2());
        int rightRowSize = BoxesRunTime.unboxToInt((Object)tuple4._3());
        long rightRowCount = BoxesRunTime.unboxToLong((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)leftRowSize), (Object)BoxesRunTime.boxToLong((long)leftRowCount), (Object)BoxesRunTime.boxToInteger((int)rightRowSize), (Object)BoxesRunTime.boxToLong((long)rightRowCount));
        int leftRowSize2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
        long leftRowCount2 = BoxesRunTime.unboxToLong((Object)tuple42._2());
        int rightRowSize2 = BoxesRunTime.unboxToInt((Object)tuple42._3());
        long rightRowCount2 = BoxesRunTime.unboxToLong((Object)tuple42._4());
        Tuple2<InputProperty, InputProperty> tuple2 = this.getInputProperties();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InputProperty leftEdge = (InputProperty)tuple2._1();
        InputProperty rightEdge = (InputProperty)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftEdge, (Object)rightEdge);
        InputProperty leftEdge2 = (InputProperty)tuple22._1();
        InputProperty rightEdge2 = (InputProperty)tuple22._2();
        return new BatchExecHashJoin((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), this.joinSpec(), leftRowSize2, rightRowSize2, leftRowCount2, rightRowCount2, this.isBroadcast(), this.leftIsBuild(), this.tryDistinctBuildRow(), leftEdge2, rightEdge2, FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType()), this.withJobStrategyHint(), this.getRelDetailedDescription());
    }

    private Tuple2<InputProperty, InputProperty> getInputProperties() {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (this.isBroadcast()) {
            tuple22 = new Tuple2((Object)InputProperty.BROADCAST_DISTRIBUTION, (Object)InputProperty.ANY_DISTRIBUTION);
        } else {
            Tuple2 tuple23;
            int[] leftKeys = this.joinSpec().getLeftKeys();
            int[] rightKeys = this.joinSpec().getRightKeys();
            Tuple2 tuple24 = tuple23 = this.leftIsBuild() ? new Tuple2((Object)leftKeys, (Object)rightKeys) : new Tuple2((Object)rightKeys, (Object)leftKeys);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            int[] buildKeys = (int[])tuple23._1();
            int[] probeKeys = (int[])tuple23._2();
            Tuple2 tuple25 = new Tuple2((Object)buildKeys, (Object)probeKeys);
            int[] buildKeys2 = (int[])tuple25._1();
            int[] probeKeys2 = (int[])tuple25._2();
            tuple22 = tuple2 = new Tuple2((Object)InputProperty.hashDistribution(buildKeys2), (Object)InputProperty.hashDistribution(probeKeys2));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InputProperty.RequiredDistribution buildRequiredDistribution = (InputProperty.RequiredDistribution)tuple2._1();
        InputProperty.RequiredDistribution probeRequiredDistribution = (InputProperty.RequiredDistribution)tuple2._2();
        Tuple2 tuple26 = new Tuple2((Object)buildRequiredDistribution, (Object)probeRequiredDistribution);
        InputProperty.RequiredDistribution buildRequiredDistribution2 = (InputProperty.RequiredDistribution)tuple26._1();
        InputProperty.RequiredDistribution probeRequiredDistribution2 = (InputProperty.RequiredDistribution)tuple26._2();
        InputProperty.DamBehavior probeDamBehavior = this.hashJoinType().buildLeftSemiOrAnti() ? InputProperty.DamBehavior.END_INPUT : InputProperty.DamBehavior.PIPELINED;
        InputProperty buildEdge = InputProperty.builder().requiredDistribution(buildRequiredDistribution2).damBehavior(InputProperty.DamBehavior.BLOCKING).priority(0).build();
        InputProperty probeEdge = InputProperty.builder().requiredDistribution(probeRequiredDistribution2).damBehavior(probeDamBehavior).priority(1).build();
        if (this.leftIsBuild()) {
            return new Tuple2((Object)buildEdge, (Object)probeEdge);
        }
        return new Tuple2((Object)probeEdge, (Object)buildEdge);
    }

    public BatchPhysicalHashJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode leftRel, RelNode rightRel, RexNode condition, JoinRelType joinType, boolean leftIsBuild, boolean isBroadcast, boolean tryDistinctBuildRow, boolean withJobStrategyHint) {
        this.cluster = cluster;
        this.leftIsBuild = leftIsBuild;
        this.isBroadcast = isBroadcast;
        this.tryDistinctBuildRow = tryDistinctBuildRow;
        this.withJobStrategyHint = withJobStrategyHint;
        super(cluster, traitSet, leftRel, rightRel, condition, joinType);
        JoinRelType joinRelType = this.getJoinType();
        JoinRelType joinRelType2 = JoinRelType.SEMI;
        JoinRelType joinRelType3 = this.getJoinType();
        JoinRelType joinRelType4 = JoinRelType.ANTI;
        this.hashJoinType = HashJoinType.of((boolean)leftIsBuild, (boolean)this.getJoinType().generatesNullsOnRight(), (boolean)this.getJoinType().generatesNullsOnLeft(), (!(joinRelType != null ? !((Object)((Object)joinRelType)).equals((Object)joinRelType2) : joinRelType2 != null) ? 1 : 0) != 0, (!(joinRelType3 != null ? !((Object)((Object)joinRelType3)).equals((Object)joinRelType4) : joinRelType4 != null) ? 1 : 0) != 0);
    }
}

