/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.ra.spi;

import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;

public class JCALocalTransaction
implements LocalTransaction {
    private volatile InternalCache cache;
    private volatile TXManagerImpl gfTxMgr;
    private volatile TransactionId tid;
    private volatile boolean initDone = false;

    JCALocalTransaction(InternalCache cache, TXManagerImpl tm) {
        this.cache = cache;
        this.gfTxMgr = tm;
        this.initDone = true;
    }

    JCALocalTransaction() {
        this.cache = null;
        this.gfTxMgr = null;
        this.initDone = false;
    }

    public void begin() throws ResourceException {
        if (!this.initDone || this.cache.isClosed()) {
            this.init();
        }
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine("JCALocalTransaction:begin invoked");
        }
        if (this.tid != null) {
            throw new LocalTransactionException("Transaction with id=" + this.tid + " is already in progress");
        }
        TXStateProxy tsp = this.gfTxMgr.getTXState();
        if (tsp == null) {
            this.gfTxMgr.begin();
            tsp = this.gfTxMgr.getTXState();
            tsp.setJCATransaction();
            this.tid = tsp.getTransactionId();
            if (this.cache.getLogger().fineEnabled()) {
                this.cache.getLogger().fine("JCALocalTransaction:begin completed transactionId=" + this.tid);
            }
        } else {
            throw new LocalTransactionException("Transaction with state=" + tsp + " is already in progress");
        }
    }

    public void commit() throws ResourceException {
        TXStateProxy tsp;
        LogWriter logger = this.cache.getLogger();
        if (logger.fineEnabled()) {
            logger.fine("JCALocalTransaction:invoked commit");
        }
        if ((tsp = this.gfTxMgr.getTXState()) != null && this.tid != tsp.getTransactionId()) {
            throw new IllegalStateException("Local Transaction associated with Tid = " + this.tid + " attempting to commit a different transaction");
        }
        try {
            this.gfTxMgr.commit();
            this.tid = null;
        }
        catch (Exception e) {
            throw new LocalTransactionException((Throwable)e);
        }
    }

    public void rollback() throws ResourceException {
        block10: {
            TXStateProxy tsp = this.gfTxMgr.getTXState();
            if (tsp != null && this.tid != tsp.getTransactionId()) {
                throw new IllegalStateException("Local Transaction associated with Tid = " + this.tid + " attempting to commit a different transaction");
            }
            LogWriter logger = this.cache.getLogger();
            if (logger.fineEnabled()) {
                logger.fine("JCALocalTransaction:invoked rollback");
            }
            try {
                this.gfTxMgr.rollback();
            }
            catch (IllegalStateException ise) {
                if (ise.getMessage().equals("Thread does not have an active transaction")) {
                    break block10;
                }
                throw new ResourceException((Throwable)ise);
            }
            catch (RuntimeException e) {
                throw new ResourceException((Throwable)e);
            }
            finally {
                this.tid = null;
            }
        }
    }

    private void init() {
        this.cache = (InternalCache)CacheFactory.getAnyInstance();
        LogWriter logger = this.cache.getLogger();
        if (logger.fineEnabled()) {
            logger.fine("JCAManagedConnection:init. Inside init");
        }
        this.gfTxMgr = this.cache.getTxManager();
        this.initDone = true;
    }

    boolean transactionInProgress() {
        return this.tid != null;
    }
}

