/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.deployment.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.utils.JarFileUtils;
import org.apache.logging.log4j.Logger;

public class DeployedJar {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic(value="This object gets updated in the production code")
    private static final MessageDigest messageDigest = DeployedJar.getMessageDigest();
    private final String artifactId;
    private final File file;
    private final byte[] md5hash;

    private static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getVersion() {
        return JarFileUtils.extractVersionFromFilename(this.file.getName());
    }

    public DeployedJar(File versionedJarFile) {
        String artifactId = JarFileUtils.toArtifactId(versionedJarFile.getName());
        this.file = versionedJarFile;
        this.artifactId = artifactId;
        if (!JarFileUtils.hasValidJarContent(versionedJarFile)) {
            throw new IllegalArgumentException("File does not contain valid JAR content: " + versionedJarFile.getAbsolutePath());
        }
        byte[] digest = null;
        try {
            if (messageDigest != null) {
                digest = this.fileDigest(this.file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.md5hash = digest;
    }

    boolean hasSameContentAs(File stagedFile) {
        byte[] compareToMd5;
        if (messageDigest == null || this.md5hash == null) {
            return false;
        }
        try {
            compareToMd5 = this.fileDigest(stagedFile);
        }
        catch (IOException ex) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("For JAR file: {}, Comparing MD5 hash {} to {}", (Object)this.file.getAbsolutePath(), (Object)new String(this.md5hash), (Object)new String(compareToMd5));
        }
        return Arrays.equals(this.md5hash, compareToMd5);
    }

    private byte[] fileDigest(File file) throws IOException {
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));){
            int read;
            byte[] data = new byte[8192];
            while ((read = fis.read(data)) > 0) {
                messageDigest.update(data, 0, read);
            }
        }
        return messageDigest.digest();
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getDeployedFileName() {
        String fileBaseName = JarFileUtils.getDeployedFileBaseName(this.file.getName());
        if (fileBaseName == null) {
            throw new IllegalStateException("file name needs to have a sequence number");
        }
        return fileBaseName + ".jar";
    }

    public String getFileCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeployedJar other = (DeployedJar)obj;
        if (this.artifactId == null) {
            return other.artifactId == null;
        }
        return this.artifactId.equals(other.artifactId);
    }

    public String toString() {
        return this.getClass().getName() + '@' + System.identityHashCode(this) + '{' + "artifactId=" + this.artifactId + ",file=" + this.file.getAbsolutePath() + ",md5hash=" + this.toHex(this.md5hash) + ",version=" + this.getVersion() + '}';
    }

    private String toHex(byte[] data) {
        StringBuilder result = new StringBuilder();
        for (byte b : data) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }
}

