/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.asyncqueue.internal;

import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.asyncqueue.internal.ParallelAsyncEventQueueImpl;
import org.apache.geode.cache.asyncqueue.internal.SerialAsyncEventQueueImpl;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AsyncEventQueueConfigurationException;
import org.apache.geode.internal.cache.wan.GatewaySenderAttributes;
import org.apache.geode.internal.cache.wan.InternalGatewaySender;
import org.apache.geode.internal.cache.xmlcache.AsyncEventQueueCreation;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.ParallelAsyncEventQueueCreation;
import org.apache.geode.internal.cache.xmlcache.SerialAsyncEventQueueCreation;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class AsyncEventQueueFactoryImpl
implements AsyncEventQueueFactory {
    private static final Logger logger = LogService.getLogger();
    public static final int DEFAULT_BATCH_TIME_INTERVAL = 5;
    private final InternalCache cache;
    private boolean pauseEventsDispatching = false;
    private final GatewaySenderAttributes gatewaySenderAttributes;

    public AsyncEventQueueFactoryImpl(InternalCache cache) {
        this(cache, new GatewaySenderAttributes(), 5);
    }

    AsyncEventQueueFactoryImpl(InternalCache cache, GatewaySenderAttributes gatewaySenderAttributes, int batchTimeInterval) {
        this.cache = cache;
        this.gatewaySenderAttributes = gatewaySenderAttributes;
        this.gatewaySenderAttributes.setBatchTimeInterval(batchTimeInterval);
    }

    @Override
    public AsyncEventQueueFactory setBatchSize(int size) {
        this.gatewaySenderAttributes.setBatchSize(size);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setPersistent(boolean isPersistent) {
        this.gatewaySenderAttributes.setPersistenceEnabled(isPersistent);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setDiskStoreName(String name) {
        this.gatewaySenderAttributes.setDiskStoreName(name);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setMaximumQueueMemory(int memory) {
        this.gatewaySenderAttributes.setMaximumQueueMemory(memory);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setDiskSynchronous(boolean isSynchronous) {
        this.gatewaySenderAttributes.setDiskSynchronous(isSynchronous);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setBatchTimeInterval(int batchTimeInterval) {
        this.gatewaySenderAttributes.setBatchTimeInterval(batchTimeInterval);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setBatchConflationEnabled(boolean isConflation) {
        this.gatewaySenderAttributes.setBatchConflationEnabled(isConflation);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setDispatcherThreads(int numThreads) {
        this.gatewaySenderAttributes.setDispatcherThreads(numThreads);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setOrderPolicy(GatewaySender.OrderPolicy policy) {
        this.gatewaySenderAttributes.setOrderPolicy(policy);
        return this;
    }

    @Override
    public AsyncEventQueueFactory addGatewayEventFilter(GatewayEventFilter filter) {
        this.gatewaySenderAttributes.addGatewayEventFilter(filter);
        return this;
    }

    @Override
    public AsyncEventQueueFactory removeGatewayEventFilter(GatewayEventFilter filter) {
        this.gatewaySenderAttributes.getGatewayEventFilters().remove(filter);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setGatewayEventSubstitutionListener(GatewayEventSubstitutionFilter filter) {
        this.gatewaySenderAttributes.setEventSubstitutionFilter(filter);
        return this;
    }

    public AsyncEventQueueFactory removeGatewayEventAlternateValueProvider(GatewayEventSubstitutionFilter provider) {
        return this;
    }

    public AsyncEventQueueFactory addAsyncEventListener(AsyncEventListener listener) {
        this.gatewaySenderAttributes.addAsyncEventListener(listener);
        return this;
    }

    @Override
    public AsyncEventQueue create(String asyncQueueId, AsyncEventListener listener) {
        AsyncEventQueue asyncEventQueue;
        if (listener == null) {
            throw new IllegalArgumentException("AsyncEventListener cannot be null");
        }
        if (this.cache instanceof CacheCreation) {
            asyncEventQueue = new AsyncEventQueueCreation(asyncQueueId, this.gatewaySenderAttributes, listener);
            if (this.pauseEventsDispatching) {
                asyncEventQueue.setPauseEventDispatching(true);
            }
            ((CacheCreation)this.cache).addAsyncEventQueue(asyncEventQueue);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating GatewaySender that underlies the AsyncEventQueue");
            }
            this.addAsyncEventListener(listener);
            InternalGatewaySender sender = (InternalGatewaySender)this.create(AsyncEventQueueImpl.getSenderIdFromAsyncEventQueueId(asyncQueueId));
            AsyncEventQueueImpl asyncEventQueueImpl = new AsyncEventQueueImpl(sender, listener);
            asyncEventQueue = asyncEventQueueImpl;
            this.cache.addAsyncEventQueue(asyncEventQueueImpl);
            if (this.pauseEventsDispatching) {
                sender.setStartEventProcessorInPausedState();
            }
            if (!this.gatewaySenderAttributes.isManualStart()) {
                sender.start();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Returning AsyncEventQueue" + asyncEventQueue);
        }
        return asyncEventQueue;
    }

    private GatewaySender create(String id) {
        AbstractGatewaySender sender;
        this.gatewaySenderAttributes.setId(id);
        if (this.gatewaySenderAttributes.getDispatcherThreads() <= 0) {
            throw new AsyncEventQueueConfigurationException(String.format("AsyncEventQueue %s can not be created with dispatcher threads less than 1", id));
        }
        if (this.gatewaySenderAttributes.isParallel()) {
            if (this.gatewaySenderAttributes.getOrderPolicy() != null && this.gatewaySenderAttributes.getOrderPolicy().equals((Object)GatewaySender.OrderPolicy.THREAD)) {
                throw new AsyncEventQueueConfigurationException(String.format("AsyncEventQueue %s can not be created with OrderPolicy %s when it is set parallel", new Object[]{id, this.gatewaySenderAttributes.getOrderPolicy()}));
            }
            sender = this.cache instanceof CacheCreation ? new ParallelAsyncEventQueueCreation(this.cache, this.gatewaySenderAttributes) : new ParallelAsyncEventQueueImpl(this.cache, this.cache.getInternalDistributedSystem().getStatisticsManager(), this.cache.getStatisticsClock(), this.gatewaySenderAttributes);
            this.cache.addGatewaySender(sender);
        } else {
            if (this.gatewaySenderAttributes.getOrderPolicy() == null && this.gatewaySenderAttributes.getDispatcherThreads() > 1) {
                this.gatewaySenderAttributes.setOrderPolicy(GatewaySender.DEFAULT_ORDER_POLICY);
            }
            sender = this.cache instanceof CacheCreation ? new SerialAsyncEventQueueCreation(this.cache, this.gatewaySenderAttributes) : new SerialAsyncEventQueueImpl(this.cache, this.cache.getInternalDistributedSystem().getStatisticsManager(), this.cache.getStatisticsClock(), this.gatewaySenderAttributes);
            this.cache.addGatewaySender(sender);
        }
        return sender;
    }

    public void configureAsyncEventQueue(AsyncEventQueue asyncQueueCreation) {
        this.gatewaySenderAttributes.setBatchSize(asyncQueueCreation.getBatchSize());
        this.gatewaySenderAttributes.setBatchTimeInterval(asyncQueueCreation.getBatchTimeInterval());
        this.gatewaySenderAttributes.setBatchConflationEnabled(asyncQueueCreation.isBatchConflationEnabled());
        this.gatewaySenderAttributes.setPersistenceEnabled(asyncQueueCreation.isPersistent());
        this.gatewaySenderAttributes.setDiskStoreName(asyncQueueCreation.getDiskStoreName());
        this.gatewaySenderAttributes.setDiskSynchronous(asyncQueueCreation.isDiskSynchronous());
        this.gatewaySenderAttributes.setMaximumQueueMemory(asyncQueueCreation.getMaximumQueueMemory());
        this.gatewaySenderAttributes.setParallel(asyncQueueCreation.isParallel());
        this.gatewaySenderAttributes.setBucketSorted(((AsyncEventQueueCreation)asyncQueueCreation).isBucketSorted());
        this.gatewaySenderAttributes.setDispatcherThreads(asyncQueueCreation.getDispatcherThreads());
        this.gatewaySenderAttributes.setOrderPolicy(asyncQueueCreation.getOrderPolicy());
        for (GatewayEventFilter filter : asyncQueueCreation.getGatewayEventFilters()) {
            this.gatewaySenderAttributes.getGatewayEventFilters().add(filter);
        }
        this.gatewaySenderAttributes.setEventSubstitutionFilter(asyncQueueCreation.getGatewayEventSubstitutionFilter());
        this.gatewaySenderAttributes.setForInternalUse(true);
        this.gatewaySenderAttributes.setForwardExpirationDestroy(asyncQueueCreation.isForwardExpirationDestroy());
    }

    @Override
    public AsyncEventQueueFactory setParallel(boolean isParallel) {
        this.gatewaySenderAttributes.setParallel(isParallel);
        return this;
    }

    public AsyncEventQueueFactory setBucketSorted(boolean isbucketSorted) {
        this.gatewaySenderAttributes.setBucketSorted(isbucketSorted);
        return this;
    }

    public AsyncEventQueueFactory setIsMetaQueue(boolean isMetaQueue) {
        this.gatewaySenderAttributes.setMetaQueue(isMetaQueue);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setForwardExpirationDestroy(boolean forward) {
        this.gatewaySenderAttributes.setForwardExpirationDestroy(forward);
        return this;
    }

    @Override
    public AsyncEventQueueFactory pauseEventDispatching() {
        this.pauseEventsDispatching = true;
        return this;
    }

    @VisibleForTesting
    protected boolean isPauseEventsDispatching() {
        return this.pauseEventsDispatching;
    }
}

