/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.CancelException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class WaitForViewInstallation
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private long viewId;
    private int processorId;

    public static void send(ClusterDistributionManager dm) throws InterruptedException {
        block2: {
            long viewId = dm.getDistribution().getView().getViewId();
            ReplyProcessor21 rp = new ReplyProcessor21((DistributionManager)dm, dm.getOtherDistributionManagerIds());
            rp.enableSevereAlertProcessing();
            dm.putOutgoing(new WaitForViewInstallation(viewId, rp.getProcessorId()));
            try {
                rp.waitForReplies();
            }
            catch (ReplyException e) {
                if (e.getCause() == null || e.getCause() instanceof CancelException || !logger.isDebugEnabled()) break block2;
                logger.debug("Reply to WaitForViewInstallation received odd exception", e.getCause());
            }
        }
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    public WaitForViewInstallation() {
    }

    private WaitForViewInstallation(long viewId, int processorId) {
        this.viewId = viewId;
        this.processorId = processorId;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    public int getDSFID() {
        return -130;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeLong(this.viewId);
        out.writeInt(this.processorId);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws ClassNotFoundException, IOException {
        super.fromData(in, context);
        this.viewId = in.readLong();
        this.processorId = in.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        boolean interrupted = false;
        try {
            dm.waitForViewInstallation(this.viewId);
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        finally {
            if (!interrupted) {
                ReplyMessage.send(this.getSender(), this.processorId, null, this.getReplySender(dm));
            }
        }
    }
}

