/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.InvalidVersionException;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractUpdateOperation
extends DistributedCacheOperation {
    private static final Logger logger = LogService.getLogger();
    @MutableForTesting
    public static volatile boolean test_InvalidVersion;
    @SuppressWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="test hook that is unset normally")
    private final long lastModifiedTime;
    private static final boolean ALWAYS_REPLICATE_UPDATES;

    public AbstractUpdateOperation(CacheEvent<?, ?> event, long lastModifiedTime) {
        super(event);
        this.lastModifiedTime = lastModifiedTime;
    }

    @Override
    protected Set<InternalDistributedMember> getRecipients() {
        CacheDistributionAdvisor advisor = this.getRegion().getCacheDistributionAdvisor();
        return advisor.adviseUpdate(this.getEvent());
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor pr) {
        super.initMessage(msg, pr);
        AbstractUpdateMessage m = (AbstractUpdateMessage)msg;
        m.lastModified = this.lastModifiedTime;
    }

    private static boolean shouldDoRemoteCreate(LocalRegion rgn, EntryEventImpl ev) {
        DataPolicy dp = rgn.getAttributes().getDataPolicy();
        return rgn.isAllEvents() && (!dp.withReplication() || !rgn.isInitialized() || !ev.getOperation().isUpdate() || rgn.getConcurrencyChecksEnabled() || ALWAYS_REPLICATE_UPDATES);
    }

    private static boolean checkIfToUpdateAfterCreateFailed(LocalRegion rgn, EntryEventImpl ev) {
        boolean doUpdate = true;
        if (ev.oldValueIsDestroyedToken()) {
            if (rgn.getVersionVector() != null && ev.getVersionTag() != null) {
                rgn.getVersionVector().recordVersion((InternalDistributedMember)ev.getDistributedMember(), ev.getVersionTag());
            }
            doUpdate = false;
        }
        if (ev.isConcurrencyConflict()) {
            if (logger.isDebugEnabled()) {
                logger.debug("basicUpdate failed with CME, not to retry:" + ev);
            }
            doUpdate = false;
        }
        return doUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean doPutOrCreate(LocalRegion rgn, EntryEventImpl ev, long lastMod) {
        try {
            long startPut;
            boolean invokeCallbacks;
            boolean doUpdate;
            boolean updated;
            block26: {
                updated = false;
                doUpdate = true;
                invokeCallbacks = true;
                if (AbstractUpdateOperation.shouldDoRemoteCreate(rgn, ev)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doPutOrCreate: attempting to update or create entry");
                    }
                    startPut = rgn.getCachePerfStats().getTime();
                    boolean isBucket = rgn.isUsedForPartitionedRegionBucket();
                    if (isBucket) {
                        BucketRegion br = (BucketRegion)rgn;
                        br.getPartitionedRegion().getPrStats().startApplyReplication();
                    }
                    try {
                        boolean overwriteDestroyed = ev.getOperation().isCreate();
                        try {
                            boolean firstBasicUpdateSuccess = rgn.basicUpdate(ev, true, false, lastMod, overwriteDestroyed, true, true);
                            if (firstBasicUpdateSuccess) {
                                rgn.getCachePerfStats().endPut(startPut, ev.isOriginRemote());
                                doUpdate = false;
                                updated = true;
                                break block26;
                            }
                            doUpdate = AbstractUpdateOperation.checkIfToUpdateAfterCreateFailed(rgn, ev);
                        }
                        catch (ConcurrentCacheModificationException ex) {
                            invokeCallbacks = false;
                            doUpdate = AbstractUpdateOperation.checkIfToUpdateAfterCreateFailed(rgn, ev);
                        }
                    }
                    finally {
                        if (isBucket) {
                            BucketRegion br = (BucketRegion)rgn;
                            br.getPartitionedRegion().getPrStats().endApplyReplication(startPut);
                        }
                    }
                }
            }
            if (doUpdate) {
                if (!ev.isLocalInvalid()) {
                    startPut = rgn.getCachePerfStats().getTime();
                    boolean overwriteDestroyed = ev.getOperation().isCreate();
                    boolean isBucket = rgn.isUsedForPartitionedRegionBucket();
                    if (isBucket) {
                        BucketRegion br = (BucketRegion)rgn;
                        br.getPartitionedRegion().getPrStats().startApplyReplication();
                    }
                    try {
                        boolean secondBasicUpdateSuccess;
                        try {
                            secondBasicUpdateSuccess = rgn.basicUpdate(ev, false, true, lastMod, overwriteDestroyed, invokeCallbacks, true);
                        }
                        catch (ConcurrentCacheModificationException ex) {
                            secondBasicUpdateSuccess = false;
                            invokeCallbacks = false;
                        }
                        if (secondBasicUpdateSuccess) {
                            rgn.getCachePerfStats().endPut(startPut, ev.isOriginRemote());
                            if (!logger.isTraceEnabled()) return true;
                            logger.trace("Processing put key {} in region {}", ev.getKey(), (Object)rgn.getFullPath());
                            return true;
                        }
                        if (rgn.isUsedForPartitionedRegionBucket() || rgn.getDataPolicy().withReplication() && rgn.getConcurrencyChecksEnabled()) {
                            ev.makeCreate();
                            boolean thirdBasicUpdateSuccess = rgn.basicUpdate(ev, false, false, lastMod, true, invokeCallbacks, false);
                            if (!thirdBasicUpdateSuccess) return true;
                            rgn.getCachePerfStats().endPut(startPut, ev.isOriginRemote());
                            return true;
                        }
                        if (rgn.getVersionVector() != null && ev.getVersionTag() != null) {
                            rgn.getVersionVector().recordVersion((InternalDistributedMember)ev.getDistributedMember(), ev.getVersionTag());
                        }
                        if (!logger.isDebugEnabled()) return true;
                        logger.debug("While processing Update message, update not performed because this key is {}", (Object)(ev.oldValueIsDestroyedToken() ? "blocked by DESTROYED/TOMBSTONE token" : "not defined"));
                        return true;
                    }
                    finally {
                        if (isBucket) {
                            BucketRegion br = (BucketRegion)rgn;
                            br.getPartitionedRegion().getPrStats().endApplyReplication(startPut);
                        }
                    }
                }
                if (!logger.isTraceEnabled()) return true;
                logger.trace("Processing create with null value provided, value not put");
                return true;
            }
            if (rgn.getVersionVector() != null && ev.getVersionTag() != null && !ev.getVersionTag().isRecorded()) {
                rgn.getVersionVector().recordVersion((InternalDistributedMember)ev.getDistributedMember(), ev.getVersionTag());
            }
            if (updated || !logger.isDebugEnabled()) return true;
            logger.debug("While processing Update message, update not performed because key was created but mirroring keys only and value not in update message, OR key was not new for sender and has been destroyed here");
            return true;
        }
        catch (CacheWriterException e) {
            throw new Error("CacheWriter should not be called", e);
        }
        catch (TimeoutException e) {
            throw new Error("DistributedLock should not be acquired", e);
        }
    }

    static {
        ALWAYS_REPLICATE_UPDATES = Boolean.getBoolean("GemFire.ALWAYS_REPLICATE_UPDATES");
    }

    public static abstract class AbstractUpdateMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected long lastModified;

        @Override
        protected boolean operateOnRegion(CacheEvent<?, ?> event, ClusterDistributionManager dm) throws EntryNotFoundException {
            EntryEventImpl ev = (EntryEventImpl)event;
            DistributedRegion rgn = (DistributedRegion)ev.getRegion();
            if (!rgn.isCacheContentProxy()) {
                this.basicOperateOnRegion(ev, rgn);
            } else if (logger.isDebugEnabled()) {
                logger.debug("UpdateMessage: this cache has already seen this event {}", event);
            }
            return true;
        }

        protected void basicOperateOnRegion(EntryEventImpl ev, DistributedRegion rgn) {
            if (logger.isDebugEnabled()) {
                logger.debug("Processing  {}", (Object)this);
            }
            try {
                long time = this.lastModified;
                if (ev.getVersionTag() != null) {
                    this.checkVersionTag(rgn, ev.getVersionTag());
                    time = ev.getVersionTag().getVersionTimeStamp();
                }
                this.appliedOperation = AbstractUpdateOperation.doPutOrCreate(rgn, ev, time);
            }
            catch (ConcurrentCacheModificationException e) {
                this.dispatchElidedEvent(rgn, ev);
                this.appliedOperation = false;
            }
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; lastModified=");
            buff.append(this.lastModified);
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.lastModified = in.readLong();
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeLong(this.lastModified);
        }

        protected void checkVersionTag(DistributedRegion rgn, VersionTag tag) {
            RegionAttributes attr = rgn.getAttributes();
            if (attr.getConcurrencyChecksEnabled() && attr.getDataPolicy().withPersistence() && attr.getScope() != Scope.GLOBAL && (tag.getMemberID() == null || test_InvalidVersion)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Version tag is missing the memberID: {}", (Object)tag);
                }
                throw new InvalidVersionException(String.format("memberID cannot be null for persistent regions: %s", tag));
            }
        }

        @Override
        protected boolean mayNotifySerialGatewaySender(ClusterDistributionManager dm) {
            return this.notifiesSerialGatewaySender(dm);
        }
    }
}

