/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DelegationTokenFetcher {
    private static final String WEBSERVICE = "webservice";
    private static final String CANCEL = "cancel";
    private static final String HELP = "help";
    private static final String HELP_SHORT = "h";
    private static final Logger LOG = LoggerFactory.getLogger(DelegationTokenFetcher.class);
    private static final String PRINT = "print";
    private static final String RENEW = "renew";
    private static final String RENEWER = "renewer";
    private static final String VERBOSE = "verbose";

    public static void main(String[] args) throws Exception {
        DelegationTokenFetcher.main((Configuration)new HdfsConfiguration(), args);
    }

    @VisibleForTesting
    public static void main(final Configuration conf, String[] args) throws Exception {
        Options fetcherOptions = new Options();
        fetcherOptions.addOption(WEBSERVICE, true, "HTTP url to reach the NameNode at").addOption(RENEWER, true, "Name of the delegation token renewer").addOption(CANCEL, false, "cancel the token").addOption(RENEW, false, "renew the token").addOption(PRINT, false, "print the token").addOption(VERBOSE, false, "print verbose output").addOption(HELP_SHORT, HELP, false, "print out help information");
        GenericOptionsParser parser = new GenericOptionsParser(conf, fetcherOptions, args);
        CommandLine cmd = parser.getCommandLine();
        final String webUrl = cmd.hasOption(WEBSERVICE) ? cmd.getOptionValue(WEBSERVICE) : null;
        final String renewer = cmd.hasOption(RENEWER) ? cmd.getOptionValue(RENEWER) : null;
        final boolean cancel = cmd.hasOption(CANCEL);
        final boolean renew = cmd.hasOption(RENEW);
        final boolean print = cmd.hasOption(PRINT);
        final boolean verbose = cmd.hasOption(VERBOSE);
        boolean help = cmd.hasOption(HELP);
        String[] remaining = parser.getRemainingArgs();
        if (help) {
            DelegationTokenFetcher.printUsage(System.out);
            return;
        }
        int commandCount = (cancel ? 1 : 0) + (renew ? 1 : 0) + (print ? 1 : 0);
        if (commandCount > 1) {
            System.err.println("ERROR: Only specify cancel, renew or print.");
            DelegationTokenFetcher.printUsage(System.err);
            return;
        }
        if (remaining.length != 1 || remaining[0].charAt(0) == '-') {
            System.err.println("ERROR: Must specify exactly one token file");
            DelegationTokenFetcher.printUsage(System.err);
            return;
        }
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        final Path tokenFile = new Path(local.getWorkingDirectory(), remaining[0]);
        UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (print) {
                    DelegationTokenFetcher.printTokens(conf, tokenFile, verbose);
                } else if (cancel) {
                    DelegationTokenFetcher.cancelTokens(conf, tokenFile);
                } else if (renew) {
                    DelegationTokenFetcher.renewTokens(conf, tokenFile);
                } else {
                    FileSystem fs = DelegationTokenFetcher.getFileSystem(conf, webUrl);
                    DelegationTokenFetcher.saveDelegationToken(conf, fs, renewer, tokenFile);
                }
                return null;
            }
        });
    }

    private static FileSystem getFileSystem(Configuration conf, String url) throws IOException {
        if (url == null) {
            return FileSystem.get((Configuration)conf);
        }
        URI fsUri = URI.create(url.replaceFirst("^http://", "webhdfs://").replaceFirst("^https://", "swebhdfs://"));
        return FileSystem.get((URI)fsUri, (Configuration)conf);
    }

    @VisibleForTesting
    static void cancelTokens(Configuration conf, Path tokenFile) throws IOException, InterruptedException {
        for (Token<?> token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
            if (!token.isManaged()) continue;
            token.cancel(conf);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Cancelled token for " + token.getService());
        }
    }

    @VisibleForTesting
    static void renewTokens(Configuration conf, Path tokenFile) throws IOException, InterruptedException {
        for (Token<?> token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
            if (!token.isManaged()) continue;
            long result = token.renew(conf);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Renewed token for " + token.getService() + " until: " + new Date(result));
        }
    }

    @VisibleForTesting
    static void saveDelegationToken(Configuration conf, FileSystem fs, String renewer, Path tokenFile) throws IOException {
        Token token = fs.getDelegationToken(renewer);
        if (null != token) {
            Credentials cred = new Credentials();
            cred.addToken(token.getService(), token);
            cred.writeTokenStorageFile(tokenFile, conf, Credentials.SerializedFormat.WRITABLE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetched token " + fs.getUri() + " for " + token.getService() + " into " + tokenFile);
            }
        } else {
            System.err.println("ERROR: Failed to fetch token from " + fs.getUri());
        }
    }

    @VisibleForTesting
    public static String printTokensToString(Configuration conf, Path tokenFile, boolean verbose) throws IOException {
        StringBuilder sbld = new StringBuilder();
        String nl = System.getProperty("line.separator");
        for (Token<?> token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
            String idStr;
            TokenIdentifier tokenId = token.decodeIdentifier();
            if (tokenId instanceof DelegationTokenIdentifier) {
                DelegationTokenIdentifier id = (DelegationTokenIdentifier)tokenId;
                idStr = verbose ? id.toString() : id.toStringStable();
            } else {
                idStr = tokenId.toString();
            }
            sbld.append("Token (").append(idStr).append(") for ").append(token.getService()).append(nl);
        }
        return sbld.toString();
    }

    static void printTokens(Configuration conf, Path tokenFile, boolean verbose) throws IOException {
        System.out.print(DelegationTokenFetcher.printTokensToString(conf, tokenFile, verbose));
    }

    private static void printUsage(PrintStream err) {
        err.println("fetchdt retrieves delegation tokens from the NameNode");
        err.println();
        err.println("fetchdt <opts> <token file>");
        err.println("Options:");
        err.println("  --webservice <url>  URL to contact NN on (starts with http:// or https://), or other filesystem URL");
        err.println("  --renewer <name>    Name of the delegation token renewer");
        err.println("  --cancel            Cancel the delegation token");
        err.println("  --renew             Renew the delegation token.  Delegation token must have been fetched using the --renewer <name> option.");
        err.println("  --print [--verbose] Print the delegation token, when --verbose is passed, print more information about the token");
        err.println();
        GenericOptionsParser.printGenericCommandUsage((PrintStream)err);
        ExitUtil.terminate((int)1);
    }

    private static Collection<Token<?>> readTokens(Path file, Configuration conf) throws IOException {
        Credentials creds = Credentials.readTokenStorageFile((Path)file, (Configuration)conf);
        return creds.getAllTokens();
    }
}

