/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.algorithm.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;

public class PopularTagsIterator
implements Iterator<SchedulingRequest> {
    private final List<SchedulingRequest> schedulingRequestList;
    private int cursor;

    public PopularTagsIterator(Collection<SchedulingRequest> schedulingRequests) {
        this.schedulingRequestList = new ArrayList<SchedulingRequest>(schedulingRequests);
        Collections.sort(this.schedulingRequestList, (o1, o2) -> (int)this.getTagPopularity((SchedulingRequest)o2) - (int)this.getTagPopularity((SchedulingRequest)o1));
        this.cursor = 0;
    }

    private long getTagPopularity(SchedulingRequest o1) {
        long max = 0L;
        for (String tag : o1.getAllocationTags()) {
            long count = this.schedulingRequestList.stream().filter(req -> req.getAllocationTags().contains(tag)).count();
            if (count <= max) continue;
            max = count;
        }
        return max;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.schedulingRequestList.size();
    }

    @Override
    public SchedulingRequest next() {
        if (this.hasNext()) {
            return this.schedulingRequestList.get(this.cursor++);
        }
        throw new NoSuchElementException();
    }
}

