/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.exception.ClassAlreadyExistsException;
import org.jsonschema2pojo.exception.GenerationException;
import org.jsonschema2pojo.rules.PrimitiveTypes;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.ParcelableHelper;
import org.jsonschema2pojo.util.ReflectionHelper;
import org.jsonschema2pojo.util.SerializableHelper;
import org.jsonschema2pojo.util.TypeUtil;

public class ObjectRule
implements Rule<JPackage, JType> {
    private final RuleFactory ruleFactory;
    private final ReflectionHelper reflectionHelper;
    private final ParcelableHelper parcelableHelper;

    protected ObjectRule(RuleFactory ruleFactory, ParcelableHelper parcelableHelper, ReflectionHelper reflectionHelper) {
        this.ruleFactory = ruleFactory;
        this.parcelableHelper = parcelableHelper;
        this.reflectionHelper = reflectionHelper;
    }

    @Override
    public JType apply(String nodeName, JsonNode node, JsonNode parent, JPackage _package, Schema schema) {
        JDefinedClass jclass;
        JType superType = this.reflectionHelper.getSuperType(nodeName, node, _package, schema);
        if (superType.isPrimitive() || this.reflectionHelper.isFinal(superType)) {
            return superType;
        }
        try {
            jclass = this.createClass(nodeName, node, _package);
        }
        catch (ClassAlreadyExistsException e) {
            return e.getExistingClass();
        }
        jclass._extends((JClass)superType);
        schema.setJavaTypeIfEmpty((JType)jclass);
        if (node.has("title")) {
            this.ruleFactory.getTitleRule().apply(nodeName, node.get("title"), node, (JDocCommentable)jclass, schema);
        }
        if (node.has("description")) {
            this.ruleFactory.getDescriptionRule().apply(nodeName, node.get("description"), node, (JDocCommentable)jclass, schema);
        }
        if (this.ruleFactory.getGenerationConfig().isGenerateBuilders() && this.ruleFactory.getGenerationConfig().isUseInnerClassBuilders()) {
            this.ruleFactory.getBuilderRule().apply(nodeName, node, parent, jclass, schema);
        }
        this.ruleFactory.getPropertiesRule().apply(nodeName, node.get("properties"), node, jclass, schema);
        if (node.has("javaInterfaces")) {
            this.addInterfaces(jclass, node.get("javaInterfaces"));
        }
        this.ruleFactory.getAdditionalPropertiesRule().apply(nodeName, node.get("additionalProperties"), node, jclass, schema);
        this.ruleFactory.getDynamicPropertiesRule().apply(nodeName, node.get("properties"), node, jclass, schema);
        if (node.has("required")) {
            this.ruleFactory.getRequiredArrayRule().apply(nodeName, node.get("required"), node, jclass, schema);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeToString()) {
            this.addToString(jclass);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeHashcodeAndEquals()) {
            this.addHashCode(jclass, node);
            this.addEquals(jclass, node);
        }
        if (this.ruleFactory.getGenerationConfig().isParcelable()) {
            this.addParcelSupport(jclass);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeConstructors()) {
            this.ruleFactory.getConstructorRule().apply(nodeName, node, parent, jclass, schema);
        }
        if (this.ruleFactory.getGenerationConfig().isSerializable()) {
            SerializableHelper.addSerializableSupport(jclass);
        }
        return jclass;
    }

    private void addParcelSupport(JDefinedClass jclass) {
        jclass._implements(jclass.owner().directClass("android.os.Parcelable"));
        this.parcelableHelper.addWriteToParcel(jclass);
        this.parcelableHelper.addDescribeContents(jclass);
        this.parcelableHelper.addCreator(jclass);
        this.parcelableHelper.addConstructorFromParcel(jclass);
        if (!this.ruleFactory.getGenerationConfig().isIncludeConstructors()) {
            jclass.constructor(1);
        }
    }

    private JDefinedClass createClass(String nodeName, JsonNode node, JPackage _package) throws ClassAlreadyExistsException {
        JDefinedClass newType;
        Annotator annotator = this.ruleFactory.getAnnotator();
        try {
            if (node.has("existingJavaType")) {
                String fqn = StringUtils.substringBefore((String)node.get("existingJavaType").asText(), (String)"<");
                if (PrimitiveTypes.isPrimitive(fqn, _package.owner())) {
                    throw new ClassAlreadyExistsException((JType)PrimitiveTypes.primitiveType(fqn, _package.owner()));
                }
                JClass existingClass = TypeUtil.resolveType((JClassContainer)_package, fqn + (node.get("existingJavaType").asText().contains("<") ? "<" + StringUtils.substringAfter((String)node.get("existingJavaType").asText(), (String)"<") : ""));
                throw new ClassAlreadyExistsException((JType)existingClass);
            }
            boolean usePolymorphicDeserialization = annotator.isPolymorphicDeserializationSupported(node);
            if (node.has("javaType")) {
                String fqn = node.path("javaType").asText();
                if (PrimitiveTypes.isPrimitive(fqn, _package.owner())) {
                    throw new GenerationException("javaType cannot refer to a primitive type (" + fqn + "), did you mean to use existingJavaType?");
                }
                if (fqn.contains("<")) {
                    throw new GenerationException("javaType does not support generic args (" + fqn + "), did you mean to use existingJavaType?");
                }
                int index = fqn.lastIndexOf(".") + 1;
                if (index == 0) {
                    fqn = _package.name() + "." + fqn;
                    index = fqn.lastIndexOf(".") + 1;
                }
                if (index >= 0 && index < fqn.length()) {
                    fqn = fqn.substring(0, index) + this.ruleFactory.getGenerationConfig().getClassNamePrefix() + fqn.substring(index) + this.ruleFactory.getGenerationConfig().getClassNameSuffix();
                }
                newType = usePolymorphicDeserialization ? _package.owner()._class(1, fqn, ClassType.CLASS) : _package.owner()._class(fqn);
            } else {
                newType = usePolymorphicDeserialization ? _package._class(1, this.ruleFactory.getNameHelper().getUniqueClassName(nodeName, node, _package), ClassType.CLASS) : _package._class(this.ruleFactory.getNameHelper().getUniqueClassName(nodeName, node, _package));
            }
        }
        catch (JClassAlreadyExistsException e) {
            throw new ClassAlreadyExistsException((JType)e.getExistingClass());
        }
        annotator.typeInfo(newType, node);
        annotator.propertyInclusion(newType, node);
        return newType;
    }

    private void addToString(JDefinedClass jclass) {
        Map fields = jclass.fields();
        JMethod toString = jclass.method(1, String.class, "toString");
        HashSet<String> excludes = new HashSet<String>(Arrays.asList(this.ruleFactory.getGenerationConfig().getToStringExcludes()));
        JBlock body = toString.body();
        JClass stringBuilderClass = jclass.owner().ref(StringBuilder.class);
        JVar sb = body.decl((JType)stringBuilderClass, "sb", (JExpression)JExpr._new((JClass)stringBuilderClass));
        body.add((JStatement)sb.invoke("append").arg((JExpression)jclass.dotclass().invoke("getName")).invoke("append").arg(JExpr.lit((char)'@')).invoke("append").arg((JExpression)jclass.owner().ref(Integer.class).staticInvoke("toHexString").arg((JExpression)jclass.owner().ref(System.class).staticInvoke("identityHashCode").arg(JExpr._this()))).invoke("append").arg(JExpr.lit((char)'[')));
        if (!jclass._extends().fullName().equals(Object.class.getName())) {
            JVar baseLength = body.decl((JType)jclass.owner().INT, "baseLength", (JExpression)sb.invoke("length"));
            JVar superString = body.decl((JType)jclass.owner().ref(String.class), "superString", (JExpression)JExpr._super().invoke("toString"));
            JBlock superToStringBlock = body._if(superString.ne(JExpr._null()))._then();
            JVar contentStart = superToStringBlock.decl((JType)jclass.owner().INT, "contentStart", (JExpression)superString.invoke("indexOf").arg(JExpr.lit((char)'[')));
            JVar contentEnd = superToStringBlock.decl((JType)jclass.owner().INT, "contentEnd", (JExpression)superString.invoke("lastIndexOf").arg(JExpr.lit((char)']')));
            JConditional superToStringInnerConditional = superToStringBlock._if(contentStart.gte(JExpr.lit((int)0)).cand(contentEnd.gt((JExpression)contentStart)));
            superToStringInnerConditional._then().add((JStatement)sb.invoke("append").arg((JExpression)superString).arg(contentStart.plus(JExpr.lit((int)1))).arg((JExpression)contentEnd));
            superToStringInnerConditional._else().add((JStatement)sb.invoke("append").arg((JExpression)superString));
            body._if(sb.invoke("length").gt((JExpression)baseLength))._then().add((JStatement)sb.invoke("append").arg(JExpr.lit((char)',')));
        }
        for (JFieldVar fieldVar : fields.values()) {
            if (excludes.contains(fieldVar.name()) || (fieldVar.mods().getValue() & 0x10) == 16) continue;
            body.add((JStatement)sb.invoke("append").arg(fieldVar.name()));
            body.add((JStatement)sb.invoke("append").arg(JExpr.lit((char)'=')));
            if (fieldVar.type().isPrimitive()) {
                body.add((JStatement)sb.invoke("append").arg((JExpression)JExpr.refthis((String)fieldVar.name())));
            } else if (fieldVar.type().isArray()) {
                if (!fieldVar.type().elementType().isPrimitive()) {
                    throw new UnsupportedOperationException("Only primitive arrays are supported");
                }
                body.add((JStatement)sb.invoke("append").arg(JOp.cond((JExpression)JExpr.refthis((String)fieldVar.name()).eq(JExpr._null()), (JExpression)JExpr.lit((String)"<null>"), (JExpression)jclass.owner().ref(Arrays.class).staticInvoke("toString").arg((JExpression)JExpr.refthis((String)fieldVar.name())).invoke("replace").arg(JExpr.lit((char)'[')).arg(JExpr.lit((char)'{')).invoke("replace").arg(JExpr.lit((char)']')).arg(JExpr.lit((char)'}')).invoke("replace").arg(JExpr.lit((String)", ")).arg(JExpr.lit((String)",")))));
            } else {
                body.add((JStatement)sb.invoke("append").arg(JOp.cond((JExpression)JExpr.refthis((String)fieldVar.name()).eq(JExpr._null()), (JExpression)JExpr.lit((String)"<null>"), (JExpression)JExpr.refthis((String)fieldVar.name()))));
            }
            body.add((JStatement)sb.invoke("append").arg(JExpr.lit((char)',')));
        }
        JConditional trailerConditional = body._if(sb.invoke("charAt").arg(sb.invoke("length").minus(JExpr.lit((int)1))).eq(JExpr.lit((char)',')));
        trailerConditional._then().add((JStatement)sb.invoke("setCharAt").arg(sb.invoke("length").minus(JExpr.lit((int)1))).arg(JExpr.lit((char)']')));
        trailerConditional._else().add((JStatement)sb.invoke("append").arg(JExpr.lit((char)']')));
        body._return((JExpression)sb.invoke("toString"));
        toString.annotate(Override.class);
    }

    private void addHashCode(JDefinedClass jclass, JsonNode node) {
        Map<String, JFieldVar> fields = this.removeFieldsExcludedFromEqualsAndHashCode(jclass.fields(), node);
        JMethod hashCode = jclass.method(1, Integer.TYPE, "hashCode");
        JBlock body = hashCode.body();
        JVar result = body.decl((JType)jclass.owner().INT, "result", JExpr.lit((int)1));
        for (JFieldVar fieldVar : fields.values()) {
            Object fieldHash;
            if ((fieldVar.mods().getValue() & 0x10) == 16) continue;
            JFieldRef fieldRef = JExpr.refthis((String)fieldVar.name());
            if (fieldVar.type().isPrimitive()) {
                if ("long".equals(fieldVar.type().name())) {
                    fieldHash = JExpr.cast((JType)jclass.owner().INT, (JExpression)fieldRef.xor(fieldRef.shrz(JExpr.lit((int)32))));
                } else if ("boolean".equals(fieldVar.type().name())) {
                    fieldHash = JOp.cond((JExpression)fieldRef, (JExpression)JExpr.lit((int)1), (JExpression)JExpr.lit((int)0));
                } else if ("int".equals(fieldVar.type().name())) {
                    fieldHash = fieldRef;
                } else if ("double".equals(fieldVar.type().name())) {
                    JClass doubleClass = jclass.owner().ref(Double.class);
                    JInvocation longField = doubleClass.staticInvoke("doubleToLongBits").arg((JExpression)fieldRef);
                    fieldHash = JExpr.cast((JType)jclass.owner().INT, (JExpression)longField.xor(longField.shrz(JExpr.lit((int)32))));
                } else {
                    fieldHash = "float".equals(fieldVar.type().name()) ? jclass.owner().ref(Float.class).staticInvoke("floatToIntBits").arg((JExpression)fieldRef) : JExpr.cast((JType)jclass.owner().INT, (JExpression)fieldRef);
                }
            } else if (fieldVar.type().isArray()) {
                if (!fieldVar.type().elementType().isPrimitive()) {
                    throw new UnsupportedOperationException("Only primitive arrays are supported");
                }
                fieldHash = jclass.owner().ref(Arrays.class).staticInvoke("hashCode").arg((JExpression)fieldRef);
            } else {
                fieldHash = JOp.cond((JExpression)fieldRef.eq(JExpr._null()), (JExpression)JExpr.lit((int)0), (JExpression)fieldRef.invoke("hashCode"));
            }
            body.assign((JAssignmentTarget)result, result.mul(JExpr.lit((int)31)).plus(fieldHash));
        }
        if (!jclass._extends().fullName().equals(Object.class.getName())) {
            body.assign((JAssignmentTarget)result, result.mul(JExpr.lit((int)31)).plus((JExpression)JExpr._super().invoke("hashCode")));
        }
        body._return((JExpression)result);
        hashCode.annotate(Override.class);
    }

    private Map<String, JFieldVar> removeFieldsExcludedFromEqualsAndHashCode(Map<String, JFieldVar> fields, JsonNode node) {
        HashMap<String, JFieldVar> filteredFields = new HashMap<String, JFieldVar>(fields);
        JsonNode properties = node.get("properties");
        if (properties != null) {
            if (node.has("excludedFromEqualsAndHashCode")) {
                JsonNode excludedArray = node.get("excludedFromEqualsAndHashCode");
                Iterator iterator = excludedArray.elements();
                while (iterator.hasNext()) {
                    String excludedPropertyName = ((JsonNode)iterator.next()).asText();
                    JsonNode excludedPropertyNode = properties.get(excludedPropertyName);
                    filteredFields.remove(this.ruleFactory.getNameHelper().getPropertyName(excludedPropertyName, excludedPropertyNode));
                }
            }
            Iterator iterator = properties.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String propertyName = (String)entry.getKey();
                JsonNode propertyNode = (JsonNode)entry.getValue();
                if (!propertyNode.has("excludedFromEqualsAndHashCode") || !propertyNode.get("excludedFromEqualsAndHashCode").asBoolean()) continue;
                filteredFields.remove(this.ruleFactory.getNameHelper().getPropertyName(propertyName, propertyNode));
            }
        }
        return filteredFields;
    }

    private void addEquals(JDefinedClass jclass, JsonNode node) {
        Map<String, JFieldVar> fields = this.removeFieldsExcludedFromEqualsAndHashCode(jclass.fields(), node);
        JMethod equals = jclass.method(1, Boolean.TYPE, "equals");
        JVar otherObject = equals.param(Object.class, "other");
        JBlock body = equals.body();
        body._if(otherObject.eq(JExpr._this()))._then()._return(JExpr.TRUE);
        body._if(otherObject._instanceof((JType)jclass).eq(JExpr.FALSE))._then()._return(JExpr.FALSE);
        JVar rhsVar = body.decl((JType)jclass, "rhs").init((JExpression)JExpr.cast((JType)jclass, (JExpression)otherObject));
        JExpression result = JExpr.lit((boolean)true);
        if (!jclass._extends().fullName().equals(Object.class.getName())) {
            result = result.cand((JExpression)JExpr._super().invoke("equals").arg((JExpression)rhsVar));
        }
        for (JFieldVar fieldVar : fields.values()) {
            JExpression fieldEquals;
            if ((fieldVar.mods().getValue() & 0x10) == 16) continue;
            JFieldRef thisFieldRef = JExpr.refthis((String)fieldVar.name());
            JFieldRef otherFieldRef = JExpr.ref((JExpression)rhsVar, (String)fieldVar.name());
            if (fieldVar.type().isPrimitive()) {
                if ("double".equals(fieldVar.type().name())) {
                    JClass doubleClass = jclass.owner().ref(Double.class);
                    fieldEquals = doubleClass.staticInvoke("doubleToLongBits").arg((JExpression)thisFieldRef).eq((JExpression)doubleClass.staticInvoke("doubleToLongBits").arg((JExpression)otherFieldRef));
                } else if ("float".equals(fieldVar.type().name())) {
                    JClass floatClass = jclass.owner().ref(Float.class);
                    fieldEquals = floatClass.staticInvoke("floatToIntBits").arg((JExpression)thisFieldRef).eq((JExpression)floatClass.staticInvoke("floatToIntBits").arg((JExpression)otherFieldRef));
                } else {
                    fieldEquals = thisFieldRef.eq((JExpression)otherFieldRef);
                }
            } else if (fieldVar.type().isArray()) {
                if (!fieldVar.type().elementType().isPrimitive()) {
                    throw new UnsupportedOperationException("Only primitive arrays are supported");
                }
                fieldEquals = jclass.owner().ref(Arrays.class).staticInvoke("equals").arg((JExpression)thisFieldRef).arg((JExpression)otherFieldRef);
            } else {
                fieldEquals = thisFieldRef.eq((JExpression)otherFieldRef).cor(thisFieldRef.ne(JExpr._null()).cand((JExpression)thisFieldRef.invoke("equals").arg((JExpression)otherFieldRef)));
            }
            result = result.cand(fieldEquals);
        }
        body._return(result);
        equals.annotate(Override.class);
    }

    private void addInterfaces(JDefinedClass jclass, JsonNode javaInterfaces) {
        for (JsonNode i : javaInterfaces) {
            jclass._implements(TypeUtil.resolveType((JClassContainer)jclass._package(), i.asText()));
        }
    }

    private boolean usesPolymorphicDeserialization(JsonNode node) {
        AnnotationStyle annotationStyle = this.ruleFactory.getGenerationConfig().getAnnotationStyle();
        if (annotationStyle == AnnotationStyle.JACKSON || annotationStyle == AnnotationStyle.JACKSON1 || annotationStyle == AnnotationStyle.JACKSON2) {
            return this.ruleFactory.getGenerationConfig().isIncludeTypeInfo() || node.has("deserializationClassProperty");
        }
        return false;
    }
}

