/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.component.ComponentRestartPolicy;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.conf.YarnServiceConf;
import org.apache.hadoop.yarn.service.conf.YarnServiceConstants;
import org.apache.hadoop.yarn.service.containerlaunch.AbstractLauncher;
import org.apache.hadoop.yarn.service.containerlaunch.CommandLineBuilder;
import org.apache.hadoop.yarn.service.containerlaunch.ContainerLaunchService;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.apache.hadoop.yarn.service.provider.ProviderService;
import org.apache.hadoop.yarn.service.provider.ProviderUtils;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProviderService
implements ProviderService,
YarnServiceConstants {
    protected static final Logger log = LoggerFactory.getLogger(AbstractProviderService.class);

    public abstract void processArtifact(AbstractLauncher var1, ComponentInstance var2, SliderFileSystem var3, Service var4, ContainerLaunchService.ComponentLaunchContext var5) throws IOException;

    public Map<String, String> buildContainerTokens(ComponentInstance instance, Container container, ContainerLaunchService.ComponentLaunchContext compLaunchContext) {
        Map<String, String> globalTokens = instance.getComponent().getScheduler().globalTokens;
        Map<String, String> tokensForSubstitution = ProviderUtils.initCompTokensForSubstitute(instance, container, compLaunchContext);
        tokensForSubstitution.putAll(globalTokens);
        return tokensForSubstitution;
    }

    public void buildContainerEnvironment(AbstractLauncher launcher, Service service, ComponentInstance instance, SliderFileSystem fileSystem, Configuration yarnConf, Container container, ContainerLaunchService.ComponentLaunchContext compLaunchContext, Map<String, String> tokensForSubstitution) throws IOException, SliderException {
        launcher.putEnv(ServiceUtils.buildEnvMap(compLaunchContext.getConfiguration(), tokensForSubstitution));
        launcher.setEnv("WORK_DIR", ApplicationConstants.Environment.PWD.$());
        launcher.setEnv("LOG_DIR", "<LOG_DIR>");
        if (System.getenv("HADOOP_USER_NAME") != null) {
            launcher.setEnv("HADOOP_USER_NAME", System.getenv("HADOOP_USER_NAME"));
        }
        launcher.setEnv("LANG", "en_US.UTF-8");
        launcher.setEnv("LC_ALL", "en_US.UTF-8");
        launcher.setEnv("LANGUAGE", "en_US.UTF-8");
        for (Map.Entry<String, String> entry : launcher.getEnv().entrySet()) {
            tokensForSubstitution.put(ServiceApiUtil.$(entry.getKey()), entry.getValue());
        }
    }

    public void buildContainerLaunchCommand(AbstractLauncher launcher, Service service, ComponentInstance instance, SliderFileSystem fileSystem, Configuration yarnConf, Container container, ContainerLaunchService.ComponentLaunchContext compLaunchContext, Map<String, String> tokensForSubstitution) throws IOException, SliderException {
        String launchCommand = compLaunchContext.getLaunchCommand();
        if (!StringUtils.isEmpty((CharSequence)launchCommand)) {
            launchCommand = ProviderUtils.substituteStrWithTokens(launchCommand, tokensForSubstitution);
            CommandLineBuilder operation = new CommandLineBuilder();
            operation.add(launchCommand);
            operation.addOutAndErrFiles("stdout.txt", "stderr.txt");
            launcher.addCommand(operation.build());
        }
    }

    public void buildContainerRetry(AbstractLauncher launcher, Configuration yarnConf, ContainerLaunchService.ComponentLaunchContext compLaunchContext, ComponentInstance instance) {
        ComponentRestartPolicy restartPolicy = instance.getComponent().getRestartPolicyHandler();
        if (restartPolicy.allowContainerRetriesForInstance(instance)) {
            launcher.setRetryContext(YarnServiceConf.getInt("yarn.service.container-failure.retry.max", 10, compLaunchContext.getConfiguration(), yarnConf), YarnServiceConf.getInt("yarn.service.container-failure.retry-interval-ms", 30000, compLaunchContext.getConfiguration(), yarnConf), YarnServiceConf.getLong("yarn.service.container-failure.validity-interval-ms", 600000L, compLaunchContext.getConfiguration(), yarnConf));
        }
    }

    @Override
    public ProviderService.ResolvedLaunchParams buildContainerLaunchContext(AbstractLauncher launcher, Service service, ComponentInstance instance, SliderFileSystem fileSystem, Configuration yarnConf, Container container, ContainerLaunchService.ComponentLaunchContext compLaunchContext) throws IOException, SliderException {
        ProviderService.ResolvedLaunchParams resolved = new ProviderService.ResolvedLaunchParams();
        this.processArtifact(launcher, instance, fileSystem, service, compLaunchContext);
        ServiceContext context = instance.getComponent().getScheduler().getContext();
        Map<String, String> tokensForSubstitution = this.buildContainerTokens(instance, container, compLaunchContext);
        this.buildContainerEnvironment(launcher, service, instance, fileSystem, yarnConf, container, compLaunchContext, tokensForSubstitution);
        ProviderUtils.createConfigFileAndAddLocalResource(launcher, fileSystem, compLaunchContext, tokensForSubstitution, instance, context, resolved);
        ProviderUtils.handleStaticFilesForLocalization(launcher, fileSystem, compLaunchContext, resolved);
        this.buildContainerLaunchCommand(launcher, service, instance, fileSystem, yarnConf, container, compLaunchContext, tokensForSubstitution);
        this.buildContainerRetry(launcher, yarnConf, compLaunchContext, instance);
        return resolved;
    }
}

