/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DecompressorStream;
import org.apache.hadoop.io.compress.FakeDecompressor;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDecompressorStream {
    private static final String TEST_STRING = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private ByteArrayInputStream bytesIn;
    private Decompressor decompressor;
    private DecompressorStream decompressorStream;

    @Before
    public void setUp() throws IOException {
        this.bytesIn = new ByteArrayInputStream(TEST_STRING.getBytes());
        this.decompressor = new FakeDecompressor();
        this.decompressorStream = new DecompressorStream((InputStream)this.bytesIn, this.decompressor, 20, 13);
    }

    @Test
    public void testReadOneByte() throws IOException {
        for (int i = 0; i < TEST_STRING.length(); ++i) {
            Assertions.assertThat((int)this.decompressorStream.read()).isEqualTo((int)TEST_STRING.charAt(i));
        }
        try {
            int ret = this.decompressorStream.read();
            Assert.fail((String)("Not reachable but got ret " + ret));
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Test
    public void testReadBuffer() throws IOException {
        byte[] buf = new byte[32];
        int bytesToRead = TEST_STRING.length();
        int i = 0;
        while (bytesToRead > 0) {
            int n = Math.min(bytesToRead, buf.length);
            int bytesRead = this.decompressorStream.read(buf, 0, n);
            Assert.assertTrue((bytesRead > 0 && bytesRead <= n ? 1 : 0) != 0);
            Assertions.assertThat((String)new String(buf, 0, bytesRead)).isEqualTo((Object)TEST_STRING.substring(i, i + bytesRead));
            bytesToRead -= bytesRead;
            i += bytesRead;
        }
        try {
            int ret = this.decompressorStream.read(buf, 0, buf.length);
            Assert.fail((String)("Not reachable but got ret " + ret));
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Test
    public void testSkip() throws IOException {
        Assertions.assertThat((long)this.decompressorStream.skip(12L)).isEqualTo(12L);
        Assertions.assertThat((int)this.decompressorStream.read()).isEqualTo((int)TEST_STRING.charAt(12));
        Assertions.assertThat((int)this.decompressorStream.read()).isEqualTo((int)TEST_STRING.charAt(13));
        Assertions.assertThat((int)this.decompressorStream.read()).isEqualTo((int)TEST_STRING.charAt(14));
        Assertions.assertThat((long)this.decompressorStream.skip(10L)).isEqualTo(10L);
        Assertions.assertThat((int)this.decompressorStream.read()).isEqualTo((int)TEST_STRING.charAt(25));
        try {
            long ret = this.decompressorStream.skip(1000L);
            Assert.fail((String)("Not reachable but got ret " + ret));
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }
}

