/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RouterResolveException;
import org.apache.hadoop.hdfs.server.federation.router.NoLocationException;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterClientProtocol;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRouterMountTableWithoutDefaultNS {
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static MountTableResolver mountTable;
    private static ClientProtocol routerProtocol;
    private static FileSystem nnFs0;
    private static FileSystem nnFs1;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 2);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        conf.setInt("dfs.federation.router.fs-limits.max-component-length", 20);
        conf.setBoolean("dfs.federation.router.default.nameservice.enable", false);
        cluster.addRouterOverrides(conf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        nnFs0 = cluster.getNamenode("ns0", null).getFileSystem();
        nnFs1 = cluster.getNamenode("ns1", null).getFileSystem();
        routerContext = cluster.getRandomRouter();
        Router router = routerContext.getRouter();
        routerProtocol = routerContext.getClient().getNamenode();
        mountTable = (MountTableResolver)router.getSubclusterResolver();
    }

    @AfterClass
    public static void tearDown() {
        if (cluster != null) {
            cluster.stopRouter(routerContext);
            cluster.shutdown();
            cluster = null;
        }
    }

    @After
    public void clearMountTable() throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        GetMountTableEntriesRequest req1 = GetMountTableEntriesRequest.newInstance((String)"/");
        GetMountTableEntriesResponse response = mountTableManager.getMountTableEntries(req1);
        for (MountTable entry : response.getEntries()) {
            RemoveMountTableEntryRequest req2 = RemoveMountTableEntryRequest.newInstance((String)entry.getSourcePath());
            mountTableManager.removeMountTableEntry(req2);
        }
    }

    private boolean addMountTable(MountTable entry) throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)entry);
        AddMountTableEntryResponse addResponse = mountTableManager.addMountTableEntry(addRequest);
        mountTable.loadCache(true);
        return addResponse.getStatus();
    }

    @Test
    public void testGetFileInfoWithSubMountPoint() throws IOException {
        MountTable addEntry = MountTable.newInstance((String)"/testdir/1", Collections.singletonMap("ns0", "/testdir/1"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        HdfsFileStatus finfo = routerProtocol.getFileInfo("/testdir");
        Assert.assertNotNull((Object)finfo);
        Assert.assertEquals((Object)"supergroup", (Object)finfo.getGroup());
        Assert.assertTrue((boolean)finfo.isDirectory());
    }

    @Test
    public void testGetFileInfoWithoutSubMountPoint() throws Exception {
        MountTable addEntry = MountTable.newInstance((String)"/testdir/1", Collections.singletonMap("ns0", "/testdir/1"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        LambdaTestUtils.intercept(RouterResolveException.class, () -> routerContext.getRouter().getRpcServer().getFileInfo("/testdir2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetContentSummaryWithSubMountPoint() throws IOException {
        MountTable addEntry = MountTable.newInstance((String)"/testdir/1/2", Collections.singletonMap("ns0", "/testdir/1/2"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        try {
            this.writeData(nnFs0, new Path("/testdir/1/2/3"), 0xA00000);
            RouterRpcServer routerRpcServer = routerContext.getRouterRpcServer();
            ContentSummary summaryFromRBF = routerRpcServer.getContentSummary("/testdir");
            Assert.assertNotNull((Object)summaryFromRBF);
            Assert.assertEquals((long)1L, (long)summaryFromRBF.getFileCount());
            Assert.assertEquals((long)0xA00000L, (long)summaryFromRBF.getLength());
        }
        finally {
            nnFs0.delete(new Path("/testdir"), true);
        }
    }

    @Test
    public void testGetAllLocations() throws IOException {
        MountTable addEntry = MountTable.newInstance((String)"/testA", Collections.singletonMap("ns0", "/testA"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        addEntry = MountTable.newInstance((String)"/testA/testB", Collections.singletonMap("ns1", "/testA/testB"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        addEntry = MountTable.newInstance((String)"/testA/testB/testC", Collections.singletonMap("ns2", "/testA/testB/testC"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        RouterClientProtocol protocol = routerContext.getRouterRpcServer().getClientProtocolModule();
        Map locations = protocol.getAllLocations("/testA");
        Assert.assertEquals((long)3L, (long)locations.size());
    }

    @Test
    public void testGetLocationsForContentSummary() throws Exception {
        MountTable addEntry = MountTable.newInstance((String)"/testA/testB", Collections.singletonMap("ns0", "/testA/testB"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        addEntry = MountTable.newInstance((String)"/testA/testB/testC", Collections.singletonMap("ns1", "/testA/testB/testC"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        RouterClientProtocol protocol = routerContext.getRouterRpcServer().getClientProtocolModule();
        List locations = protocol.getLocationsForContentSummary("/testA");
        Assert.assertEquals((long)2L, (long)locations.size());
        for (RemoteLocation location : locations) {
            String nsId = location.getNameserviceId();
            if ("ns0".equals(nsId)) {
                Assert.assertEquals((Object)"/testA/testB", (Object)location.getDest());
                continue;
            }
            if ("ns1".equals(nsId)) {
                Assert.assertEquals((Object)"/testA/testB/testC", (Object)location.getDest());
                continue;
            }
            Assert.fail((String)("Unexpected NS " + nsId));
        }
        LambdaTestUtils.intercept(NoLocationException.class, () -> protocol.getLocationsForContentSummary("/testB"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetContentSummary() throws Exception {
        try {
            MountTable addEntry = MountTable.newInstance((String)"/testA", Collections.singletonMap("ns0", "/testA"));
            Assert.assertTrue((boolean)this.addMountTable(addEntry));
            addEntry = MountTable.newInstance((String)"/testA/testB", Collections.singletonMap("ns0", "/testA/testB"));
            Assert.assertTrue((boolean)this.addMountTable(addEntry));
            addEntry = MountTable.newInstance((String)"/testA/testB/testC", Collections.singletonMap("ns1", "/testA/testB/testC"));
            Assert.assertTrue((boolean)this.addMountTable(addEntry));
            this.writeData(nnFs0, new Path("/testA/testB/file1"), 0x100000);
            this.writeData(nnFs1, new Path("/testA/testB/testC/file2"), 0x100000);
            this.writeData(nnFs1, new Path("/testA/testB/testC/file3"), 0x100000);
            RouterRpcServer routerRpcServer = routerContext.getRouterRpcServer();
            ContentSummary summary = routerRpcServer.getContentSummary("/testA");
            Assert.assertEquals((long)3L, (long)summary.getFileCount());
            Assert.assertEquals((long)0x300000L, (long)summary.getLength());
            LambdaTestUtils.intercept(NoLocationException.class, () -> routerRpcServer.getContentSummary("/testB"));
        }
        finally {
            nnFs0.delete(new Path("/testA"), true);
            nnFs1.delete(new Path("/testA"), true);
        }
    }

    void writeData(FileSystem fs, Path path, int fileLength) throws IOException {
        try (FSDataOutputStream outputStream = fs.create(path);){
            for (int writeSize = 0; writeSize < fileLength; ++writeSize) {
                outputStream.write(writeSize);
            }
        }
    }
}

