/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ConfigurationMutationACLPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ConfigurationMutationACLPolicyFactory;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.CSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.ConfigurationUpdateAssembler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStoreFactory;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableCSConfigurationProvider
implements CSConfigurationProvider,
MutableConfigurationProvider {
    public static final Logger LOG = LoggerFactory.getLogger(MutableCSConfigurationProvider.class);
    private Configuration schedConf;
    private Configuration oldConf;
    private YarnConfigurationStore confStore;
    private ConfigurationMutationACLPolicy aclMutationPolicy;
    private RMContext rmContext;
    private final ReentrantReadWriteLock formatLock = new ReentrantReadWriteLock();

    public MutableCSConfigurationProvider(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    protected Configuration getInitSchedulerConfig() {
        Configuration initialSchedConf = new Configuration(false);
        initialSchedConf.addResource("capacity-scheduler.xml");
        return initialSchedConf;
    }

    @Override
    public void init(Configuration config) throws IOException {
        this.confStore = YarnConfigurationStoreFactory.getStore(config);
        this.initializeSchedConf();
        try {
            this.confStore.initialize(config, this.schedConf, this.rmContext);
            this.confStore.checkVersion();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.schedConf = this.confStore.retrieve();
        this.aclMutationPolicy = ConfigurationMutationACLPolicyFactory.getPolicy(config);
        this.aclMutationPolicy.init(config, this.rmContext);
    }

    @Override
    public void close() throws IOException {
        this.confStore.close();
    }

    @VisibleForTesting
    protected YarnConfigurationStore getConfStore() {
        return this.confStore;
    }

    @Override
    public CapacitySchedulerConfiguration loadConfiguration(Configuration configuration) throws IOException {
        Configuration loadedConf = new Configuration(this.schedConf);
        loadedConf.addResource(configuration);
        return new CapacitySchedulerConfiguration(loadedConf, false);
    }

    @Override
    public Configuration getConfiguration() {
        return new Configuration(this.schedConf);
    }

    @Override
    public long getConfigVersion() throws Exception {
        return this.confStore.getConfigVersion();
    }

    @Override
    public ConfigurationMutationACLPolicy getAclMutationPolicy() {
        return this.aclMutationPolicy;
    }

    @Override
    public YarnConfigurationStore.LogMutation logAndApplyMutation(UserGroupInformation user, SchedConfUpdateInfo confUpdate) throws Exception {
        this.oldConf = new Configuration(this.schedConf);
        CapacitySchedulerConfiguration proposedConf = new CapacitySchedulerConfiguration(this.schedConf, false);
        Map<String, String> kvUpdate = ConfigurationUpdateAssembler.constructKeyValueConfUpdate(proposedConf, confUpdate);
        YarnConfigurationStore.LogMutation log = new YarnConfigurationStore.LogMutation(kvUpdate, user.getShortUserName());
        this.confStore.logMutation(log);
        this.applyMutation(proposedConf, kvUpdate);
        this.schedConf = proposedConf;
        return log;
    }

    @Override
    public Configuration applyChanges(Configuration oldConfiguration, SchedConfUpdateInfo confUpdate) throws IOException {
        CapacitySchedulerConfiguration proposedConf = new CapacitySchedulerConfiguration(oldConfiguration, false);
        Map<String, String> kvUpdate = ConfigurationUpdateAssembler.constructKeyValueConfUpdate(proposedConf, confUpdate);
        this.applyMutation(proposedConf, kvUpdate);
        return proposedConf;
    }

    private void applyMutation(Configuration conf, Map<String, String> kvUpdate) {
        for (Map.Entry<String, String> kv : kvUpdate.entrySet()) {
            if (kv.getValue() == null) {
                conf.unset(kv.getKey());
                continue;
            }
            conf.set(kv.getKey(), kv.getValue());
        }
    }

    @Override
    public void formatConfigurationInStore(Configuration config) throws Exception {
        this.formatLock.writeLock().lock();
        try {
            this.confStore.format();
            this.oldConf = new Configuration(this.schedConf);
            this.initializeSchedConf();
            this.confStore.initialize(config, this.schedConf, this.rmContext);
            this.confStore.checkVersion();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.formatLock.writeLock().unlock();
        }
    }

    private void initializeSchedConf() {
        Configuration initialSchedConf = this.getInitSchedulerConfig();
        this.schedConf = new Configuration(false);
        for (Map.Entry kv : initialSchedConf) {
            this.schedConf.set((String)kv.getKey(), (String)kv.getValue());
        }
    }

    @Override
    public void revertToOldConfig(Configuration config) throws Exception {
        this.formatLock.writeLock().lock();
        try {
            this.schedConf = this.oldConf;
            this.confStore.format();
            this.confStore.initialize(config, this.oldConf, this.rmContext);
            this.confStore.checkVersion();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.formatLock.writeLock().unlock();
        }
    }

    @Override
    public void confirmPendingMutation(YarnConfigurationStore.LogMutation pendingMutation, boolean isValid) throws Exception {
        this.formatLock.readLock().lock();
        try {
            this.confStore.confirmMutation(pendingMutation, isValid);
            if (!isValid) {
                this.schedConf = this.oldConf;
            }
        }
        finally {
            this.formatLock.readLock().unlock();
        }
    }

    @Override
    public void reloadConfigurationFromStore() throws Exception {
        this.formatLock.readLock().lock();
        try {
            this.schedConf = this.confStore.retrieve();
        }
        finally {
            this.formatLock.readLock().unlock();
        }
    }
}

