/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.webapp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.service.webapp.ApiServer;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiServerWebApp
extends AbstractService {
    private static final Logger logger = LoggerFactory.getLogger(ApiServerWebApp.class);
    private static final String SEP = ";";
    private HttpServer2 apiServer;
    private InetSocketAddress bindAddress;

    public static void main(String[] args) throws IOException {
        ApiServerWebApp apiWebApp = new ApiServerWebApp();
        try {
            apiWebApp.init((Configuration)new YarnConfiguration());
            apiWebApp.serviceStart();
        }
        catch (Exception e) {
            logger.error("Got exception starting", (Throwable)e);
            apiWebApp.close();
        }
    }

    public ApiServerWebApp() {
        super(ApiServerWebApp.class.getName());
    }

    protected void serviceStart() throws Exception {
        this.bindAddress = this.getConfig().getSocketAddr("yarn.service.api-server.address", "0.0.0.0:", 9191);
        logger.info("YARN API server running on " + this.bindAddress);
        if (UserGroupInformation.isSecurityEnabled()) {
            this.doSecureLogin(this.getConfig());
        }
        this.startWebApp();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.apiServer != null) {
            this.apiServer.stop();
        }
        super.serviceStop();
    }

    private void doSecureLogin(Configuration conf) throws IOException {
        SecurityUtil.login((Configuration)conf, (String)"yarn.resourcemanager.keytab", (String)"yarn.resourcemanager.principal", (String)this.bindAddress.getHostName());
        this.addFilters(conf);
    }

    private void addFilters(Configuration conf) {
        boolean hasHadoopAuthFilterInitializer = false;
        String filterInitializerConfKey = "hadoop.http.filter.initializers";
        Class[] initializersClasses = conf.getClasses(filterInitializerConfKey, new Class[0]);
        ArrayList<String> targets = new ArrayList<String>();
        if (initializersClasses != null) {
            for (Class initializer : initializersClasses) {
                if (initializer.getName().equals(AuthenticationFilterInitializer.class.getName())) {
                    hasHadoopAuthFilterInitializer = true;
                    break;
                }
                targets.add(initializer.getName());
            }
        }
        if (!hasHadoopAuthFilterInitializer) {
            targets.add(AuthenticationFilterInitializer.class.getName());
            conf.set(filterInitializerConfKey, StringUtils.join((CharSequence)",", targets));
        }
    }

    private void startWebApp() throws IOException {
        URI uri = URI.create("http://" + NetUtils.getHostPortString((InetSocketAddress)this.bindAddress));
        this.apiServer = new HttpServer2.Builder().setName("api-server").setConf(this.getConfig()).setSecurityEnabled(UserGroupInformation.isSecurityEnabled()).setUsernameConfKey("yarn.resourcemanager.webapp.spnego-principal").setKeytabConfKey("yarn.resourcemanager.webapp.spnego-keytab-file").addEndpoint(uri).build();
        String apiPackages = ApiServer.class.getPackage().getName() + SEP + GenericExceptionHandler.class.getPackage().getName() + SEP + YarnJacksonJaxbJsonProvider.class.getPackage().getName();
        this.apiServer.addJerseyResourcePackage(apiPackages, "/*");
        try {
            logger.info("Service starting up. Logging start...");
            this.apiServer.start();
            logger.info("Server status = {}", (Object)this.apiServer.toString());
            for (org.eclipse.jetty.webapp.Configuration conf : this.apiServer.getWebAppContext().getConfigurations()) {
                logger.info("Configurations = {}", (Object)conf);
            }
            logger.info("Context Path = {}", Collections.singletonList(this.apiServer.getWebAppContext().getContextPath()));
            logger.info("ResourceBase = {}", Collections.singletonList(this.apiServer.getWebAppContext().getResourceBase()));
            logger.info("War = {}", Collections.singletonList(this.apiServer.getWebAppContext().getWar()));
        }
        catch (Exception ex) {
            logger.error("Hadoop HttpServer2 App **failed**", (Throwable)ex);
            throw ex;
        }
    }
}

