/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;

public final class RouterDelegationTokenSupport {
    private RouterDelegationTokenSupport() {
    }

    public static String encodeDelegationTokenInformation(AbstractDelegationTokenSecretManager.DelegationTokenInformation token) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bos);
            WritableUtils.writeVInt((DataOutput)out, (int)token.password.length);
            out.write(token.password);
            out.writeLong(token.renewDate);
            out.flush();
            byte[] tokenInfoBytes = bos.toByteArray();
            return Base64.getUrlEncoder().encodeToString(tokenInfoBytes);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to encode token.", ex);
        }
    }

    public static AbstractDelegationTokenSecretManager.DelegationTokenInformation decodeDelegationTokenInformation(byte[] tokenBytes) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(tokenBytes));
        AbstractDelegationTokenSecretManager.DelegationTokenInformation token = new AbstractDelegationTokenSecretManager.DelegationTokenInformation(0L, null);
        int len = WritableUtils.readVInt((DataInput)in);
        token.password = new byte[len];
        in.readFully(token.password);
        token.renewDate = in.readLong();
        return token;
    }
}

