/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.inject.Inject;
import com.sun.jersey.api.client.Client;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.server.router.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.router.webapp.RouterBlock;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class NodesBlock
extends RouterBlock {
    private final Router router;

    @Inject
    NodesBlock(Router router, View.ViewContext ctx) {
        super(router, ctx);
        this.router = router;
    }

    protected void render(HtmlBlock.Block html) {
        NodesInfo nodesInfo;
        boolean isEnabled = this.isYarnFederationEnabled();
        String subClusterName = this.$("node.subcluster");
        String state = this.$("node.state");
        String nodeLabel = this.$("node.label");
        if (subClusterName != null && !subClusterName.isEmpty() && !"router".equalsIgnoreCase(subClusterName)) {
            this.initSubClusterMetricsOverviewTable(html, subClusterName);
            nodesInfo = this.getSubClusterNodesInfo(subClusterName);
        } else {
            html.__(MetricsOverviewTable.class);
            nodesInfo = this.getYarnFederationNodesInfo(isEnabled);
        }
        this.initYarnFederationNodesOfCluster(nodesInfo, html, state, nodeLabel);
    }

    private NodesInfo getYarnFederationNodesInfo(boolean isEnabled) {
        Configuration config = this.router.getConfig();
        String webAddress = isEnabled ? WebAppUtils.getRouterWebAppURLWithScheme((Configuration)this.router.getConfig()) : WebAppUtils.getRMWebAppURLWithScheme((Configuration)config);
        return this.getSubClusterNodesInfoByWebAddress(webAddress);
    }

    private NodesInfo getSubClusterNodesInfo(String subCluster) {
        try {
            String webAddress;
            SubClusterId subClusterId = SubClusterId.newInstance((String)subCluster);
            FederationStateStoreFacade facade = FederationStateStoreFacade.getInstance((Configuration)this.router.getConfig());
            SubClusterInfo subClusterInfo = facade.getSubCluster(subClusterId);
            if (subClusterInfo != null && (webAddress = subClusterInfo.getRMWebServiceAddress()) != null && !webAddress.isEmpty()) {
                String herfWebAppAddress = WebAppUtils.getHttpSchemePrefix((Configuration)this.router.getConfig()) + webAddress;
                return this.getSubClusterNodesInfoByWebAddress(herfWebAppAddress);
            }
        }
        catch (Exception e) {
            LOG.error("get NodesInfo From SubCluster = {} error.", (Object)subCluster, (Object)e);
        }
        return null;
    }

    private NodesInfo getSubClusterNodesInfoByWebAddress(String webAddress) {
        Configuration conf = this.router.getConfig();
        Client client = RouterWebServiceUtil.createJerseyClient(conf);
        NodesInfo nodes = RouterWebServiceUtil.genericForward(webAddress, null, NodesInfo.class, HTTPMethods.GET, "/ws/v1/cluster/nodes", null, null, conf, client);
        client.destroy();
        return nodes;
    }

    private void initYarnFederationNodesOfCluster(NodesInfo nodesInfo, HtmlBlock.Block html, String filterState, String filterLabel) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#nodes").thead().tr().th(".nodelabels", "Node Labels").th(".rack", "Rack").th(".state", "Node State").th(".nodeaddress", "Node Address").th(".nodehttpaddress", "Node HTTP Address").th(".lastHealthUpdate", "Last health-update").th(".healthReport", "Health-report").th(".containers", "Containers").th(".mem", "Mem Used").th(".mem", "Mem Avail").th(".vcores", "VCores Used").th(".vcores", "VCores Avail").th(".nodeManagerVersion", "Version").__()).__()).tbody();
        if (nodesInfo != null && CollectionUtils.isNotEmpty((Collection)nodesInfo.getNodes())) {
            for (NodeInfo info : nodesInfo.getNodes()) {
                if (filterState != null && !filterState.isEmpty() && !filterState.equals(info.getState()) || !filterLabel.equals("*") && (filterLabel.isEmpty() ? !info.getNodeLabels().isEmpty() : !info.getNodeLabels().contains(filterLabel))) continue;
                int usedMemory = (int)info.getUsedMemory();
                int availableMemory = (int)info.getAvailableMemory();
                Hamlet.TR row = tbody.tr();
                row.td().__(new Object[]{StringUtils.join((CharSequence)",", (Iterable)info.getNodeLabels())}).__();
                row.td().__(new Object[]{info.getRack()}).__();
                row.td().__(new Object[]{info.getState()}).__();
                row.td().__(new Object[]{info.getNodeId()}).__();
                boolean isInactive = false;
                if (isInactive) {
                    row.td().__(new Object[]{"N/A"}).__();
                } else {
                    String httpAddress = info.getNodeHTTPAddress();
                    String herfWebAppAddress = "";
                    if (httpAddress != null && !httpAddress.isEmpty()) {
                        herfWebAppAddress = WebAppUtils.getHttpSchemePrefix((Configuration)this.router.getConfig()) + httpAddress;
                    }
                    row.td().a(herfWebAppAddress, httpAddress).__();
                }
                ((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)row.td().br().$title(String.valueOf(info.getLastHealthUpdate())).__()).__(new Object[]{new Date(info.getLastHealthUpdate())}).__()).td(info.getHealthReport()).td(String.valueOf(info.getNumContainers())).td().br().$title(String.valueOf(usedMemory)).__()).__(new Object[]{StringUtils.byteDesc((long)((long)usedMemory * 0x100000L))}).__()).td().br().$title(String.valueOf(availableMemory)).__()).__(new Object[]{StringUtils.byteDesc((long)((long)availableMemory * 0x100000L))}).__()).td(String.valueOf(info.getUsedVirtualCores())).td(String.valueOf(info.getAvailableVirtualCores())).td(info.getVersion()).__();
            }
        }
        ((Hamlet.TABLE)tbody.__()).__();
    }
}

