/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class UGIResolver {
    public static final int USER_STRID_OFFSET = 40;
    public static final int GROUP_STRID_OFFSET = 16;
    public static final long USER_GROUP_STRID_MASK = 0xFFFFFFL;
    private final Map<String, Integer> users;
    private final Map<String, Integer> groups;

    protected final long buildPermissionStatus(String owner, String group, short permission) {
        long userId = this.users.get(owner).intValue();
        if (0L != (0xFFFFFFFFFF000000L & userId)) {
            throw new IllegalArgumentException("UID must fit in 24 bits");
        }
        long groupId = this.groups.get(group).intValue();
        if (0L != (0xFFFFFFFFFF000000L & groupId)) {
            throw new IllegalArgumentException("GID must fit in 24 bits");
        }
        return (userId & 0xFFFFFFL) << 40 | (groupId & 0xFFFFFFL) << 16 | (long)permission;
    }

    public UGIResolver() {
        this(new HashMap<String, Integer>(), new HashMap<String, Integer>());
    }

    UGIResolver(Map<String, Integer> users, Map<String, Integer> groups) {
        this.users = users;
        this.groups = groups;
    }

    public Map<Integer, String> ugiMap() {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        for (Map m : Arrays.asList(this.users, this.groups)) {
            for (Map.Entry e : m.entrySet()) {
                String s = (String)ret.put((Integer)e.getValue(), (String)e.getKey());
                if (s == null) continue;
                throw new IllegalStateException("Duplicate mapping: " + e.getValue() + " " + s + " " + (String)e.getKey());
            }
        }
        return ret;
    }

    public abstract void addUser(String var1);

    protected void addUser(String name, int id) {
        Integer uid = this.users.put(name, id);
        if (uid != null) {
            throw new IllegalArgumentException("Duplicate mapping: " + name + " " + uid + " " + id);
        }
    }

    public abstract void addGroup(String var1);

    protected void addGroup(String name, int id) {
        Integer gid = this.groups.put(name, id);
        if (gid != null) {
            throw new IllegalArgumentException("Duplicate mapping: " + name + " " + gid + " " + id);
        }
    }

    protected void resetUGInfo() {
        this.users.clear();
        this.groups.clear();
    }

    public long resolve(FileStatus s) {
        String resolvedGroup = this.group(s.getGroup());
        String resolvedOwner = this.user(s.getOwner());
        FsPermission resolvedPermission = this.permission(s.getPermission());
        return this.buildPermissionStatus(resolvedOwner, resolvedGroup, resolvedPermission.toShort());
    }

    private long resolve(AclStatus aclStatus) {
        String resolvedOwner = this.user(aclStatus.getOwner());
        String resolvedGroup = this.group(aclStatus.getGroup());
        FsPermission resolvedPermision = this.permission(aclStatus.getPermission());
        return this.buildPermissionStatus(resolvedOwner, resolvedGroup, resolvedPermision.toShort());
    }

    protected String user(String s) {
        return s;
    }

    protected String group(String s) {
        return s;
    }

    public FsPermission permission(FsPermission s) {
        return s;
    }

    public long getPermissionsProto(FileStatus remoteStatus, AclStatus remoteAcl) {
        this.addUGI(remoteStatus, remoteAcl);
        if (remoteAcl == null) {
            return this.resolve(remoteStatus);
        }
        return this.resolve(remoteAcl);
    }

    private void addUGI(FileStatus remoteStatus, AclStatus remoteAcl) {
        if (remoteAcl != null) {
            this.addUser(remoteAcl.getOwner());
            this.addGroup(remoteAcl.getGroup());
            for (AclEntry entry : remoteAcl.getEntries()) {
                String name = entry.getName();
                if (name == null) continue;
                if (entry.getType() == AclEntryType.USER) {
                    this.addUser(name);
                    continue;
                }
                if (entry.getType() != AclEntryType.GROUP) continue;
                this.addGroup(name);
            }
        } else {
            this.addUser(remoteStatus.getOwner());
            this.addGroup(remoteStatus.getGroup());
        }
    }
}

