/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdConstants;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdToken;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdTokenType;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.stream.Collector;

abstract class RntbdTokenStream<T extends Enum<T>> {
    final ImmutableMap<Short, T> headers;
    final ImmutableMap<T, RntbdToken> tokens;

    RntbdTokenStream(ImmutableSet<T> headers, ImmutableMap<Short, T> ids) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(ids, "ids");
        Collector collector = Maps.toImmutableEnumMap(h -> h, x$0 -> RntbdToken.create((RntbdConstants.RntbdHeader)x$0));
        this.tokens = (ImmutableMap)headers.stream().collect(collector);
        this.headers = ids;
    }

    final int computeCount() {
        int count = 0;
        for (RntbdToken token : this.tokens.values()) {
            if (!token.isPresent()) continue;
            ++count;
        }
        return count;
    }

    final int computeLength() {
        int total = 0;
        for (RntbdToken token : this.tokens.values()) {
            total += token.computeLength();
        }
        return total;
    }

    static <T extends RntbdTokenStream<?>> T decode(ByteBuf in, T stream) {
        while (in.readableBytes() > 0) {
            short id = in.readShortLE();
            RntbdTokenType type = RntbdTokenType.fromId(in.readByte());
            RntbdToken token = (RntbdToken)stream.tokens.get(stream.headers.get((Object)id));
            if (token == null) {
                token = RntbdToken.create(new UndefinedHeader(id, type));
            }
            token.decode(in);
        }
        for (RntbdToken token : stream.tokens.values()) {
            if (token.isPresent() || !token.isRequired()) continue;
            String reason = String.format("Required token not found on RNTBD stream: type: %s, identifier: %s", new Object[]{token.getType(), token.getId()});
            throw new IllegalStateException(reason);
        }
        return stream;
    }

    final void encode(ByteBuf out) {
        for (RntbdToken token : this.tokens.values()) {
            token.encode(out);
        }
    }

    final RntbdToken get(T header) {
        return (RntbdToken)this.tokens.get(header);
    }

    final void releaseBuffers() {
        for (RntbdToken token : this.tokens.values()) {
            token.releaseBuffer();
        }
    }

    private static final class UndefinedHeader
    implements RntbdConstants.RntbdHeader {
        private final short id;
        private final RntbdTokenType type;

        UndefinedHeader(short id, RntbdTokenType type) {
            this.id = id;
            this.type = type;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public String name() {
            return "Undefined";
        }

        @Override
        public RntbdTokenType type() {
            return this.type;
        }
    }
}

