/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import java.util.List;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.sls.scheduler.ContainerSimulator;

public abstract class AMDefinition {
    protected int jobCount;
    protected String amType;
    protected String user;
    protected String queue;
    protected long jobStartTime;
    protected long jobFinishTime;
    protected List<ContainerSimulator> taskContainers;
    protected Resource amResource;
    protected String labelExpression;
    protected String oldAppId;

    public AMDefinition(AmDefinitionBuilder builder) {
        this.jobStartTime = builder.jobStartTime;
        this.jobFinishTime = builder.jobFinishTime;
        this.amType = builder.amType;
        this.taskContainers = builder.taskContainers;
        this.labelExpression = builder.labelExpression;
        this.user = builder.user;
        this.amResource = builder.amResource;
        this.queue = builder.queue;
        this.jobCount = builder.jobCount;
        this.oldAppId = builder.jobId;
    }

    public String getAmType() {
        return this.amType;
    }

    public String getUser() {
        return this.user;
    }

    public String getOldAppId() {
        return this.oldAppId;
    }

    public long getJobStartTime() {
        return this.jobStartTime;
    }

    public long getJobFinishTime() {
        return this.jobFinishTime;
    }

    public List<ContainerSimulator> getTaskContainers() {
        return this.taskContainers;
    }

    public Resource getAmResource() {
        return this.amResource;
    }

    public String getLabelExpression() {
        return this.labelExpression;
    }

    public String getQueue() {
        return this.queue;
    }

    public int getJobCount() {
        return this.jobCount;
    }

    public static abstract class AmDefinitionBuilder {
        private static final String DEFAULT_USER = "default";
        protected int jobCount = 1;
        protected String amType = "mapreduce";
        protected String user = "default";
        protected String queue;
        protected String jobId;
        protected long jobStartTime;
        protected long jobFinishTime;
        protected List<ContainerSimulator> taskContainers;
        protected Resource amResource;
        protected String labelExpression = null;
    }
}

