/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.request;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;

public class EncryptionSecrets {
    private final Optional<String> ssecCustomerKey;
    private final String ssecCustomerKeyMd5;

    public EncryptionSecrets(Optional<String> sseCustomerKey) {
        this.ssecCustomerKey = sseCustomerKey;
        this.ssecCustomerKeyMd5 = sseCustomerKey.map(key -> {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                return Base64.getEncoder().encodeToString(md.digest(Base64.getDecoder().decode((String)key)));
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("MD5 algorithm not available", e);
            }
        }).orElse(null);
    }

    @Generated
    public static EncryptionSecretsBuilder builder() {
        return new EncryptionSecretsBuilder();
    }

    @Generated
    public Optional<String> getSsecCustomerKey() {
        return this.ssecCustomerKey;
    }

    @Generated
    public String getSsecCustomerKeyMd5() {
        return this.ssecCustomerKeyMd5;
    }

    @Generated
    public static class EncryptionSecretsBuilder {
        @Generated
        private Optional<String> sseCustomerKey;

        @Generated
        EncryptionSecretsBuilder() {
        }

        @Generated
        public EncryptionSecretsBuilder sseCustomerKey(Optional<String> sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        @Generated
        public EncryptionSecrets build() {
            return new EncryptionSecrets(this.sseCustomerKey);
        }

        @Generated
        public String toString() {
            return "EncryptionSecrets.EncryptionSecretsBuilder(sseCustomerKey=" + this.sseCustomerKey + ")";
        }
    }
}

