/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.blockgenerator;

import java.net.URI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.tools.dynamometer.blockgenerator.BlockInfo;
import org.apache.hadoop.tools.dynamometer.blockgenerator.GenerateDNBlockInfosReducer;
import org.apache.hadoop.tools.dynamometer.blockgenerator.XMLParserMapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class GenerateBlockImagesDriver
extends Configured
implements Tool {
    public static final String FSIMAGE_INPUT_PATH_ARG = "fsimage_input_path";
    public static final String BLOCK_IMAGE_OUTPUT_ARG = "block_image_output_dir";
    public static final String NUM_REDUCERS_ARG = "num_reducers";
    public static final String NUM_DATANODES_ARG = "num_datanodes";
    public static final String NUM_DATANODES_KEY = "dyno.blockgen.num.datanodes";

    public GenerateBlockImagesDriver(Configuration conf) {
        this.setConf(conf);
    }

    public int run(String[] args) throws Exception {
        Options options = new Options();
        options.addOption("h", "help", false, "Shows this message");
        options.addOption(Option.builder((String)FSIMAGE_INPUT_PATH_ARG).argName("Input path of the XML fsImage").hasArg().required(true).desc("Input path to the Hadoop fsImage XML file (required)").build());
        options.addOption(Option.builder((String)BLOCK_IMAGE_OUTPUT_ARG).argName("BlockImage output directory").hasArg().required(true).desc("Directory where the generated files containing the block listing for each DataNode should be stored (required)").build());
        options.addOption(Option.builder((String)NUM_REDUCERS_ARG).argName("Number of reducers").hasArg().required(false).desc("Number of reducers for this job (defaults to number of datanodes)").build());
        options.addOption(Option.builder((String)NUM_DATANODES_ARG).argName("Number of datanodes").hasArg().required(true).desc("Number of DataNodes to create blocks for (required)").build());
        PosixParser parser = new PosixParser();
        CommandLine cli = parser.parse(options, args);
        if (cli.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(200, "hadoop jar dynamometer-*.jar org.apache.hadoop.tools.dynamometer.blockgenerator.GenerateBlockImagesDriver [options]", null, options, null);
            return 0;
        }
        String fsImageInputPath = cli.getOptionValue(FSIMAGE_INPUT_PATH_ARG);
        String blockImageOutputDir = cli.getOptionValue(BLOCK_IMAGE_OUTPUT_ARG);
        int numDataNodes = Integer.parseInt(cli.getOptionValue(NUM_DATANODES_ARG));
        int numReducers = Integer.parseInt(cli.getOptionValue(NUM_REDUCERS_ARG, String.valueOf(numDataNodes)));
        FileSystem fs = FileSystem.get((URI)new URI(blockImageOutputDir), (Configuration)this.getConf());
        Job job = Job.getInstance((Configuration)this.getConf(), (String)"Create blocksImages for Dynamometer");
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(fsImageInputPath)});
        Path blockImagesDir = new Path(blockImageOutputDir);
        fs.delete(blockImagesDir, true);
        FileOutputFormat.setOutputPath((Job)job, (Path)blockImagesDir);
        job.getConfiguration().setInt(NUM_DATANODES_KEY, numDataNodes);
        job.setJarByClass(GenerateBlockImagesDriver.class);
        job.setInputFormatClass(NoSplitTextInputFormat.class);
        job.setNumReduceTasks(numReducers);
        LazyOutputFormat.setOutputFormatClass((Job)job, TextOutputFormat.class);
        job.setMapperClass(XMLParserMapper.class);
        job.setReducerClass(GenerateDNBlockInfosReducer.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(BlockInfo.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        boolean success = job.waitForCompletion(true);
        return success ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        GenerateBlockImagesDriver driver = new GenerateBlockImagesDriver(new Configuration());
        System.exit(ToolRunner.run((Tool)driver, (String[])args));
    }

    public static class NoSplitTextInputFormat
    extends TextInputFormat {
        public boolean isSplitable(JobContext context, Path file) {
            return false;
        }
    }
}

